/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.Ref;
import convex.core.data.RefDirect;
import convex.core.exceptions.InvalidDataException;
import convex.core.exceptions.MissingDataException;
import convex.core.store.AStore;
import convex.core.store.Stores;
import convex.core.util.Utils;
import java.lang.ref.SoftReference;

public class RefSoft<T extends ACell>
extends Ref<T> {
    protected SoftReference<T> softRef;
    protected final AStore store;

    protected RefSoft(AStore store, SoftReference<T> ref, Hash hash, int flags) {
        super(hash, flags);
        this.softRef = ref;
        this.store = store;
    }

    protected RefSoft(AStore store, T value, Hash hash, int flags) {
        this(store, RefSoft.createSoftReference(value), hash, flags);
    }

    protected RefSoft(AStore store, Hash hash) {
        this(store, new SoftReference<Object>(null), hash, 0);
    }

    private static <T extends ACell> SoftReference<T> createSoftReference(T value) {
        if (!value.isCanonical()) {
            value = value.toCanonical();
        }
        return new SoftReference<T>(value);
    }

    @Override
    public RefSoft<T> withFlags(int newFlags) {
        if (this.flags == newFlags) {
            return this;
        }
        return new RefSoft<SoftReference<T>>(this.store, this.softRef, this.hash, newFlags);
    }

    public static <T extends ACell> RefSoft<T> create(AStore store, T value, int flags) {
        Hash hash = Hash.compute(value);
        return new RefSoft<T>(store, value, hash, flags);
    }

    public static <T extends ACell> RefSoft<T> createForHash(Hash hash) {
        return new RefSoft<T>(Stores.current(), hash);
    }

    @Override
    public T getValue() {
        ACell result = (ACell)this.softRef.get();
        if (result == null) {
            Ref storeRef = this.store.refForHash(this.hash);
            if (storeRef == null) {
                throw (RuntimeException)Utils.sneakyThrow(new MissingDataException(this.store, this.hash));
            }
            this.flags = Ref.mergeFlags(this.flags, storeRef.flags);
            result = storeRef.getValue();
            this.softRef = storeRef instanceof RefSoft ? ((RefSoft)storeRef).softRef : new SoftReference<ACell>(result);
        }
        return (T)result;
    }

    @Override
    public boolean isMissing() {
        ACell result = (ACell)this.softRef.get();
        if (result != null) {
            return false;
        }
        Ref storeRef = this.store.refForHash(this.hash);
        if (storeRef == null) {
            return true;
        }
        this.softRef = storeRef instanceof RefSoft ? ((RefSoft)storeRef).softRef : new SoftReference(storeRef.getValue());
        this.flags = Ref.mergeFlags(this.flags, storeRef.flags);
        return false;
    }

    @Override
    public boolean equals(Ref<T> a) {
        if (a.hash != null) {
            return this.hash.equals(a.hash);
        }
        return Utils.equals(this.getValue(), a.getValue());
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public RefDirect<T> toDirect() {
        return RefDirect.create(this.getValue(), this.hash, this.flags);
    }

    @Override
    public RefSoft<T> toSoft(AStore store) {
        return this.withStore(store);
    }

    @Override
    public Hash getHash() {
        return this.hash;
    }

    @Override
    public void validate() throws InvalidDataException {
        super.validate();
        if (this.hash == null) {
            throw new InvalidDataException("Hash should never be null in soft ref", this);
        }
        ACell val = (ACell)this.softRef.get();
        boolean embedded = this.isEmbedded();
        if (embedded != Format.isEmbedded(val)) {
            throw new InvalidDataException("Embedded flag [" + embedded + "] inconsistent with value", this);
        }
    }

    @Override
    public Ref<T> withValue(T newValue) {
        if (this.softRef.get() != newValue) {
            return new RefSoft<T>(this.store, newValue, this.hash, this.flags);
        }
        return this;
    }

    public RefSoft<T> withStore(AStore store) {
        if (this.store == store) {
            return this;
        }
        return new RefSoft<SoftReference<T>>(store, this.softRef, this.hash, this.flags);
    }

    @Override
    public int estimatedEncodingSize() {
        return this.isEmbedded() ? 140 : 33;
    }

    @Override
    public Ref<T> ensureCanonical() {
        return this;
    }

    public AStore getStore() {
        return this.store;
    }

    public boolean hasReference() {
        return this.softRef.get() != null;
    }
}

