/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ABlob;
import convex.core.data.ABlobLike;
import convex.core.data.AVector;
import convex.core.data.BlobBuilder;
import convex.core.data.Ref;
import convex.core.data.StringShort;
import convex.core.data.Strings;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMChar;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.util.Utils;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

public abstract class AString
extends ABlobLike<CVMChar>
implements Comparable<AString> {
    protected long length;

    protected AString(long length) {
        this.length = length;
    }

    @Override
    public AType getType() {
        return Types.STRING;
    }

    @Override
    public boolean print(BlobBuilder sb, long limit) {
        long n = this.count();
        if (!sb.check(limit - (n + 2L))) {
            long avail = limit - sb.count();
            if (avail > 0L) {
                sb.append('\"');
                sb.append(this.slice(0L, avail - 1L));
            }
            return false;
        }
        sb.append('\"');
        this.printEscaped(sb, 0L, n);
        sb.append('\"');
        return sb.check(limit);
    }

    @Override
    public long count() {
        return this.length;
    }

    protected abstract void printEscaped(BlobBuilder var1, long var2, long var4);

    @Override
    public final StringShort empty() {
        return StringShort.EMPTY;
    }

    public final int charAt(long i) {
        int utf = this.intAt(i);
        int cp = CVMChar.codepointFromUTFInt(utf);
        return cp;
    }

    public int intAt(long index) {
        int r = 0;
        for (int i = 0; i < 4; ++i) {
            r |= (0xFF & this.byteAt(index + (long)i)) << 8 * (3 - i);
        }
        return r;
    }

    @Override
    public abstract byte byteAt(long var1);

    @Override
    public CVMChar get(long i) {
        return CVMChar.create(this.charAt((int)i));
    }

    @Override
    public Ref<CVMChar> getElementRef(long i) {
        return this.get(i).getRef();
    }

    @Override
    public int getBytes(byte[] dest, int destOffset) {
        return this.toBlob().getBytes(dest, destOffset);
    }

    @Override
    public abstract int compareTo(AString var1);

    @Override
    public final String toString() {
        int n = Utils.checkedInt(this.count());
        ByteBuffer bb = this.toBlob().toByteBuffer();
        int cn = Math.min(4096, n);
        CharBuffer cb = CharBuffer.allocate(cn);
        CharsetDecoder dec = Strings.getDecoder();
        StringBuilder sb = new StringBuilder(cn);
        while (bb.hasRemaining()) {
            CoderResult cr = dec.decode(bb, cb, false);
            cb.flip();
            sb.append(cb.toString());
            cb.clear();
            if (cr != CoderResult.UNDERFLOW) continue;
            break;
        }
        dec.decode(bb, cb, true);
        cb.flip();
        sb.append(cb.toString());
        cb.clear();
        return sb.toString();
    }

    @Override
    public AString toCVMString(long limit) {
        if (limit < this.count()) {
            return null;
        }
        return this;
    }

    public AString append(AString b) {
        if (this.length == 0L) {
            return b;
        }
        long n = b.count();
        if (n == 0L) {
            return this;
        }
        return Strings.create(this.toBlob().append(b.toBlob()));
    }

    public abstract AString slice(long var1, long var3);

    public AVector<AString> split(CVMChar c) {
        long start = 0L;
        AVector<AString> acc = Vectors.empty();
        long n = this.count();
        int cp = c.getCodePoint();
        int utfLength = CVMChar.utfLength(cp);
        int pos = 0;
        while ((long)pos < n) {
            int ch = this.charAt(pos);
            if (ch == cp) {
                acc = acc.append(this.slice(start, pos));
                start = pos += utfLength;
                continue;
            }
            int inc = CVMChar.utfLength(ch);
            if (inc < 0) {
                inc = 1;
            }
            pos += inc;
        }
        acc = acc.append(this.slice(start, n));
        return acc;
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = 48;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public abstract int encodeRaw(byte[] var1, int var2);

    public abstract int writeRawData(byte[] var1, int var2);

    @Override
    public final byte getTag() {
        return 48;
    }

    @Override
    public final int hashCode() {
        return this.toBlob().hashCode();
    }

    public abstract ABlob toBlob();

    public AString append(String string) {
        return this.append(Strings.create(string));
    }
}

