/*
 * Decompiled with CFR 0.152.
 */
package convex.core.crypto;

import convex.core.crypto.AKeyPair;
import convex.core.crypto.Providers;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.crypto.spec.SecretKeySpec;

public class PFXTools {
    public static final String KEYSTORE_TYPE = "PKCS12";

    private static char[] password(String passPhrase) {
        return passPhrase == null ? new char[]{} : passPhrase.toCharArray();
    }

    public static KeyStore createStore(File keyFile, String passPhrase) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance(KEYSTORE_TYPE);
        Providers.init();
        char[] pwdArray = PFXTools.password(passPhrase);
        ks.load(null, pwdArray);
        ks = PFXTools.saveStore(ks, keyFile, passPhrase);
        return ks;
    }

    public static KeyStore loadStore(File keyFile, String passPhrase) throws IOException, GeneralSecurityException {
        Providers.init();
        KeyStore ks = KeyStore.getInstance(KEYSTORE_TYPE);
        char[] pwdArray = PFXTools.password(passPhrase);
        try (FileInputStream fis = new FileInputStream(keyFile);){
            ks.load(fis, pwdArray);
        }
        return ks;
    }

    public static KeyStore saveStore(KeyStore ks, File keyFile, String passPhrase) throws GeneralSecurityException, IOException {
        char[] pwdArray = PFXTools.password(passPhrase);
        File parent = keyFile.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        try (FileOutputStream fos = new FileOutputStream(keyFile);){
            ks.store(fos, pwdArray);
        }
        return ks;
    }

    public static AKeyPair getKeyPair(KeyStore ks, String alias, String passphrase) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException {
        char[] pwdArray = passphrase.toCharArray();
        Key sk = ks.getKey(alias, pwdArray);
        return AKeyPair.create(sk.getEncoded());
    }

    public static KeyStore setKeyPair(KeyStore ks, AKeyPair kp, String passPhrase) throws IOException, GeneralSecurityException {
        return PFXTools.setKeyPair(ks, kp.getAccountKey().toHexString(), kp, passPhrase);
    }

    public static KeyStore setKeyPair(KeyStore ks, String alias, AKeyPair kp, String passPhrase) throws IOException, GeneralSecurityException {
        if (passPhrase == null) {
            throw new IllegalArgumentException("Password is mandatory for private key");
        }
        char[] pwdArray = passPhrase.toCharArray();
        byte[] bs = kp.getSeed().getBytes();
        SecretKeySpec secretKeyPrivate = new SecretKeySpec(bs, "Ed25519");
        ks.setKeyEntry(alias, secretKeyPrivate, pwdArray, null);
        return ks;
    }
}

