/*
 * Decompiled with CFR 0.152.
 */
package convex.core;

import convex.core.Belief;
import convex.core.BeliefMerge;
import convex.core.Block;
import convex.core.BlockResult;
import convex.core.ErrorCodes;
import convex.core.Order;
import convex.core.Result;
import convex.core.State;
import convex.core.crypto.AKeyPair;
import convex.core.data.ACell;
import convex.core.data.AMap;
import convex.core.data.AVector;
import convex.core.data.AccountKey;
import convex.core.data.Address;
import convex.core.data.Hash;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.core.data.Maps;
import convex.core.data.PeerStatus;
import convex.core.data.Ref;
import convex.core.data.SignedData;
import convex.core.data.Vectors;
import convex.core.data.prim.ANumeric;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.InvalidDataException;
import convex.core.init.Init;
import convex.core.lang.AOp;
import convex.core.lang.Context;
import convex.core.store.AStore;
import convex.core.store.Stores;
import convex.core.transactions.ATransaction;
import convex.core.util.Utils;
import java.io.IOException;

public class Peer {
    private final AccountKey peerKey;
    private final transient AKeyPair keyPair;
    private final Belief belief;
    private final long timestamp;
    private final long position;
    private final long historyPosition;
    private final State state;
    private final State genesis;
    private final AVector<BlockResult> blockResults;

    private Peer(AKeyPair kp, Belief belief, long pos, State state, State genesis, long history, AVector<BlockResult> results, long timeStamp) {
        this.keyPair = kp;
        this.peerKey = kp.getAccountKey();
        this.belief = belief;
        this.state = state;
        this.genesis = genesis;
        this.timestamp = timeStamp;
        this.position = pos;
        this.historyPosition = history;
        this.blockResults = results;
    }

    public static Peer fromData(AKeyPair keyPair, AMap<Keyword, ACell> peerData) {
        Belief belief = (Belief)peerData.get(Keywords.BELIEF);
        AVector results = (AVector)peerData.get(Keywords.RESULTS);
        State state = (State)peerData.get(Keywords.STATE);
        State genesis = (State)peerData.get(Keywords.GENESIS);
        long pos = ((CVMLong)peerData.get(Keywords.POSITION)).longValue();
        long hpos = ((CVMLong)peerData.get(Keywords.HISTORY)).longValue();
        long timestamp = ((CVMLong)peerData.get(Keywords.TIMESTAMP)).longValue();
        return new Peer(keyPair, belief, pos, state, genesis, hpos, results, timestamp);
    }

    public AMap<Keyword, ACell> toData() {
        return Maps.of(Keywords.BELIEF, this.belief, Keywords.HISTORY, CVMLong.create(this.historyPosition), Keywords.RESULTS, this.blockResults, Keywords.POSITION, CVMLong.create(this.position), Keywords.STATE, this.state, Keywords.GENESIS, this.genesis, Keywords.TIMESTAMP, this.timestamp);
    }

    public static Peer create(AKeyPair peerKP, State genesis) {
        Belief belief = Belief.createSingleOrder(peerKP);
        return new Peer(peerKP, belief, 0L, genesis, genesis, 0L, Vectors.empty(), genesis.getTimestamp().longValue());
    }

    public static Peer create(AKeyPair peerKP, State initialState, Belief remoteBelief) {
        Peer peer = Peer.create(peerKP, initialState);
        peer = peer.updateTimestamp(Utils.getCurrentTimestamp());
        try {
            peer = peer.mergeBeliefs(remoteBelief);
            return peer;
        }
        catch (Throwable e) {
            throw (RuntimeException)Utils.sneakyThrow(e);
        }
    }

    public static Peer restorePeer(AStore store, AKeyPair keyPair) throws IOException {
        return Peer.restorePeer(store, keyPair, null);
    }

    public static Peer restorePeer(AStore store, AKeyPair keyPair, ACell rootKey) throws IOException {
        AMap<Keyword, ACell> peerData = Peer.getPeerData(store, rootKey);
        if (peerData == null) {
            return null;
        }
        Peer peer = Peer.fromData(keyPair, peerData);
        return peer;
    }

    public static AMap<Keyword, ACell> getPeerData(AStore store) throws IOException {
        return Peer.getPeerData(store, null);
    }

    public static AMap<Keyword, ACell> getPeerData(AStore store, ACell rootKey) throws IOException {
        Stores.setCurrent(store);
        Hash root = store.getRootHash();
        Ref ref = store.refForHash(root);
        if (ref == null) {
            return null;
        }
        if (ref.getStatus() < 2) {
            return null;
        }
        if (rootKey == null) {
            return (AMap)ref.getValue();
        }
        return (AMap)((AMap)ref.getValue()).get(rootKey);
    }

    public static Peer createGenesisPeer(AKeyPair keyPair, State genesisState) {
        if (keyPair == null) {
            throw new IllegalArgumentException("Peer initialisation requires a keypair");
        }
        if (genesisState == null) {
            genesisState = Init.createState(Utils.listOf(keyPair.getAccountKey()));
            genesisState = genesisState.withTimestamp(Utils.getCurrentTimestamp());
        }
        return Peer.create(keyPair, genesisState);
    }

    public Peer updateTimestamp(long newTimestamp) {
        if (newTimestamp <= this.timestamp) {
            return this;
        }
        return new Peer(this.keyPair, this.belief, this.position, this.state, this.genesis, this.historyPosition, this.blockResults, newTimestamp);
    }

    public Context executeQuery(ACell form, Address address) {
        State state = this.getConsensusState();
        if (address == null) {
            address = Init.CORE_ADDRESS;
        }
        Context ctx = Context.createFake(state, address);
        if (state.getAccount(address) == null) {
            return ctx.withError(ErrorCodes.NOBODY, "Account does not exist for query: " + address);
        }
        Context ectx = ctx.expandCompile(form);
        if (ectx.isExceptional()) {
            return ectx;
        }
        AOp op = (AOp)ectx.getResult();
        Context rctx = ctx.run(op);
        return rctx;
    }

    public long estimateCost(ATransaction trans) {
        Address address = trans.getOrigin();
        State state = this.getConsensusState();
        Context ctx = this.executeDryRun(trans);
        return state.getBalance(address) - ctx.getState().getBalance(address);
    }

    public Context executeDryRun(ATransaction transaction) {
        Context ctx = this.getConsensusState().applyTransaction(transaction);
        return ctx;
    }

    public Context executeQuery(ACell form) {
        return this.executeQuery(form, Init.getGenesisAddress());
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public AccountKey getPeerKey() {
        return this.peerKey;
    }

    public Address getController() {
        PeerStatus ps = this.getConsensusState().getPeer(this.peerKey);
        if (ps == null) {
            return null;
        }
        return ps.getController();
    }

    public AKeyPair getKeyPair() {
        return this.keyPair;
    }

    public Belief getBelief() {
        return this.belief;
    }

    public <T extends ACell> SignedData<T> sign(T value) {
        return SignedData.create(this.keyPair, value);
    }

    public State getConsensusState() {
        return this.state;
    }

    public Peer mergeBeliefs(Belief ... beliefs) throws InvalidDataException {
        Peer p;
        Order newOrder;
        long ncp;
        Belief belief = this.getBelief();
        BeliefMerge mc = BeliefMerge.create(belief, this.keyPair, this.timestamp, this.getConsensusState());
        Belief newBelief = mc.merge(beliefs);
        long ocp = this.getFinalityPoint();
        if (ocp > (ncp = (newOrder = newBelief.getOrder(this.peerKey)).getConsensusPoint(3))) {
            System.err.println("Receding consensus? Old CP=" + ocp + ", New CP=" + ncp);
        }
        if ((p = this.updateBelief(newBelief)) == this) {
            return this;
        }
        return p;
    }

    public Peer pruneHistory(long ts) {
        if (this.blockResults.count() == 0L) {
            return this;
        }
        long firstTs = ((BlockResult)this.blockResults.get(0)).getState().getTimestamp().longValue();
        if (ts < firstTs) {
            return this;
        }
        long ix = Utils.binarySearch(this.blockResults, br -> br.getState().getTimestamp(), (a, b) -> a.compareTo((ANumeric)b), CVMLong.create(ts));
        return this;
    }

    public Peer updateBelief(Belief newBelief) {
        if (this.belief == newBelief) {
            return this;
        }
        return new Peer(this.keyPair, newBelief, this.position, this.state, this.genesis, this.historyPosition, this.blockResults, this.timestamp);
    }

    public Peer updateState() {
        Order myOrder = this.belief.getOrder(this.peerKey);
        long consensusPoint = myOrder.getConsensusPoint(3);
        AVector<SignedData<Block>> blocks = myOrder.getBlocks();
        State s = this.state;
        long stateIndex = this.position;
        if (stateIndex >= consensusPoint) {
            return this;
        }
        AVector<BlockResult> newResults = this.blockResults;
        while (stateIndex < consensusPoint) {
            SignedData<Block> block = blocks.get(stateIndex);
            BlockResult br = s.applyBlock(block);
            s = br.getState();
            newResults = newResults.append(br);
            ++stateIndex;
        }
        return new Peer(this.keyPair, this.belief, stateIndex, s, this.genesis, this.historyPosition, newResults, this.timestamp);
    }

    public Result getResult(long blockIndex, long txIndex) {
        BlockResult br = this.getBlockResult(blockIndex);
        if (br == null) {
            return null;
        }
        return br.getResult(txIndex);
    }

    public BlockResult getBlockResult(long i) {
        if (i < this.historyPosition) {
            return null;
        }
        long brix = i - this.historyPosition;
        if (brix >= this.blockResults.count()) {
            return null;
        }
        return this.blockResults.get(brix);
    }

    public Peer proposeBlock(Block block) {
        SignedData<Block> signedBlock = this.sign(block);
        Belief newBelief = this.belief.proposeBlock(this.keyPair, signedBlock);
        Peer result = this;
        long blockTimeStamp = block.getTimeStamp();
        if (blockTimeStamp > result.getTimestamp()) {
            result = result.updateTimestamp(blockTimeStamp);
        }
        result = result.updateBelief(newBelief);
        result = result.updateState();
        return result;
    }

    public long getFinalityPoint() {
        Order order = this.getPeerOrder();
        if (order == null) {
            return 0L;
        }
        return order.getConsensusPoint(3);
    }

    public Order getPeerOrder() {
        return this.getBelief().getOrder(this.peerKey);
    }

    public Order getOrder(AccountKey peerKey) {
        return this.getBelief().getOrder(peerKey);
    }

    public Hash getNetworkID() {
        return this.genesis.getHash();
    }

    public long getPosition() {
        return this.position;
    }

    public State getGenesisState() {
        return this.genesis;
    }
}

