/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.AMapEntry;
import convex.core.data.ASequence;
import convex.core.data.AVector;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.data.VectorLeaf;
import convex.core.data.Vectors;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.RT;
import convex.core.util.Errors;
import convex.core.util.Utils;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class MapEntry<K extends ACell, V extends ACell>
extends AMapEntry<K, V>
implements Comparable<MapEntry<K, V>> {
    private final Ref<K> keyRef;
    private final Ref<V> valueRef;

    private MapEntry(Ref<K> key, Ref<V> value) {
        super(2L);
        this.keyRef = key;
        this.valueRef = value;
    }

    @Override
    public AType getType() {
        return Types.VECTOR;
    }

    public static <K extends ACell, V extends ACell> MapEntry<K, V> createRef(Ref<? extends K> keyRef, Ref<? extends V> valueRef) {
        return new MapEntry<K, V>(keyRef, valueRef);
    }

    public static <K extends ACell, V extends ACell> MapEntry<K, V> create(K key, V value) {
        return MapEntry.createRef(Ref.get(key), Ref.get(value));
    }

    public static <K extends ACell, V extends ACell> MapEntry<K, V> of(Object key, Object value) {
        return MapEntry.create(RT.cvm(key), RT.cvm(value));
    }

    @Override
    public MapEntry<K, V> withValue(V value) {
        if (value == this.getValue()) {
            return this;
        }
        return new MapEntry<K, V>(this.keyRef, Ref.get(value));
    }

    @Override
    public <R extends ACell> AVector<R> assoc(long i, R a) {
        if (i == 0L) {
            return this.withKey(a);
        }
        if (i == 1L) {
            return this.withValue(a);
        }
        return null;
    }

    @Override
    protected MapEntry<K, V> withKey(K key) {
        if (key == this.getKey()) {
            return this;
        }
        return new MapEntry<K, V>(Ref.get(key), this.valueRef);
    }

    @Override
    public K getKey() {
        return this.keyRef.getValue();
    }

    @Override
    public <R extends ACell> AVector<R> map(Function<? super ACell, ? extends R> mapper) {
        return Vectors.of(mapper.apply((ACell)this.getKey()), mapper.apply((ACell)this.getValue()));
    }

    @Override
    public <R> R reduce(BiFunction<? super R, ? super ACell, ? extends R> func, R value) {
        R result = func.apply(value, (ACell)this.getKey());
        result = func.apply(result, (ACell)this.getKey());
        return result;
    }

    @Override
    protected <R> void copyToArray(R[] arr, int offset) {
        arr[offset] = this.getKey();
        arr[offset + 1] = this.getValue();
    }

    public Hash getKeyHash() {
        return this.getKeyRef().getHash();
    }

    @Override
    public V getValue() {
        return this.valueRef.getValue();
    }

    public Ref<K> getKeyRef() {
        return this.keyRef;
    }

    public Ref<V> getValueRef() {
        return this.valueRef;
    }

    @Override
    public int compareTo(MapEntry<K, V> o) {
        if (this == o) {
            return 0;
        }
        return this.keyRef.compareTo(o.keyRef);
    }

    @Override
    public final int getRefCount() {
        return 2;
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        if (i >> 1 != 0) {
            throw new IndexOutOfBoundsException(i);
        }
        return i == 0 ? this.keyRef : this.valueRef;
    }

    @Override
    public MapEntry<K, V> updateRefs(IRefFunction func) {
        Ref<?> newKeyRef = func.apply(this.keyRef);
        Ref<?> newValueRef = func.apply(this.valueRef);
        if (this.keyRef == newKeyRef && this.valueRef == newValueRef) {
            return this;
        }
        MapEntry result = new MapEntry(newKeyRef, newValueRef);
        result.attachEncoding(this.encoding);
        return result;
    }

    @Override
    public boolean equals(ACell o) {
        if (o == null) {
            return false;
        }
        if (o.getTag() != -128) {
            return false;
        }
        AVector v = (AVector)o;
        if (v.count() != 2L) {
            return false;
        }
        return this.getEncoding().equals(o.getEncoding());
    }

    public boolean equals(MapEntry<K, V> b) {
        if (this == b) {
            return true;
        }
        return this.keyRef.equals(b.keyRef) && this.valueRef.equals(b.valueRef);
    }

    public boolean keyEquals(MapEntry<K, V> b) {
        return this.keyRef.equals(b.keyRef);
    }

    @Override
    public <R extends ACell> AVector<R> toVector() {
        return new VectorLeaf(new Ref[]{this.keyRef, this.valueRef});
    }

    @Override
    public boolean contains(Object o) {
        return Utils.equals(o, this.getKey()) || Utils.equals(o, this.getValue());
    }

    @Override
    public ACell get(long i) {
        if (i == 0L) {
            return this.getKey();
        }
        if (i == 1L) {
            return this.getValue();
        }
        throw new IndexOutOfBoundsException(Errors.badIndex(i));
    }

    @Override
    public Ref<ACell> getElementRef(long i) {
        if (i == 0L) {
            return this.keyRef;
        }
        if (i == 1L) {
            return this.valueRef;
        }
        throw new IndexOutOfBoundsException(Errors.badIndex(i));
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = -128;
        pos = Format.writeVLCLong(bs, pos, 2L);
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = this.keyRef.encode(bs, pos);
        pos = this.valueRef.encode(bs, pos);
        return pos;
    }

    public static int encodeCompressed(MapEntry<?, ?> me, byte[] bs, int pos) {
        if (me == null) {
            bs[pos++] = 0;
        } else {
            bs[pos++] = -128;
            pos = me.encodeRaw(bs, pos);
        }
        return pos;
    }

    @Override
    public final boolean isCVMValue() {
        return true;
    }

    @Override
    public int estimatedEncodingSize() {
        return 281;
    }

    @Override
    public void visitElementRefs(Consumer<Ref<ACell>> f) {
        f.accept(this.keyRef);
        f.accept(this.valueRef);
    }

    @Override
    public <R extends ACell> AVector<R> concat(ASequence<R> b) {
        return this.toVector().concat((ASequence)b);
    }

    @Override
    public <R extends ACell> AVector<R> subVector(long start, long length) {
        AVector<R> vec = this.toVector();
        return vec.subVector(start, length);
    }

    @Override
    public void validate() throws InvalidDataException {
        super.validate();
        this.keyRef.validate();
        this.valueRef.validate();
        if (!RT.isCVM((ACell)this.getKey())) {
            throw new InvalidDataException("MapEntry key not a CVM value: " + (ACell)this.getKey(), this);
        }
        if (!RT.isCVM((ACell)this.getValue())) {
            throw new InvalidDataException("MapEntry value not a CVM value: " + (ACell)this.getValue(), this);
        }
    }

    @Override
    public void validateCell() throws InvalidDataException {
    }

    @Override
    public byte getTag() {
        return -128;
    }

    public static MapEntry convertOrNull(AVector v) {
        if (v.count() != 2L) {
            return null;
        }
        return MapEntry.createRef(v.getElementRef(0L), v.getElementRef(1L));
    }

    @Override
    public boolean isCanonical() {
        return false;
    }

    @Override
    public ACell toCanonical() {
        return this.toVector();
    }
}

