/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.Block;
import convex.core.data.ACell;
import convex.core.data.AHashMap;
import convex.core.data.AMap;
import convex.core.data.ASequence;
import convex.core.data.AVector;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.Keyword;
import convex.core.data.MapEntry;
import convex.core.data.Maps;
import convex.core.data.Ref;
import convex.core.data.Vectors;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.lang.impl.RecordFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public abstract class ARecord
extends AMap<Keyword, ACell> {
    public static final ARecord DEFAULT_VALUE = Block.create(0L, Vectors.empty());

    protected ARecord(long n) {
        super(n);
    }

    @Override
    public AType getType() {
        return Types.RECORD;
    }

    @Override
    public int estimatedEncodingSize() {
        return (int)(140L * this.count);
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public ARecord toCanonical() {
        return this;
    }

    @Override
    public boolean isCVMValue() {
        return true;
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        AVector<Keyword> keys = this.getKeys();
        for (Keyword key : keys) {
            pos = Format.write(bs, pos, this.get(key));
        }
        return pos;
    }

    @Override
    public final AVector<Keyword> getKeys() {
        return this.getFormat().getKeys();
    }

    @Override
    public AVector<ACell> values() {
        int n = this.size();
        ACell[] os = new ACell[n];
        RecordFormat format = this.getFormat();
        for (int i = 0; i < n; ++i) {
            os[i] = this.get(format.getKey(i));
        }
        return Vectors.create(os);
    }

    @Override
    public final ACell get(Object key) {
        if (!(key instanceof Keyword)) {
            return null;
        }
        return this.get((Keyword)key);
    }

    @Override
    public abstract ACell get(ACell var1);

    @Override
    public abstract byte getTag();

    public ACell[] getValuesArray() {
        int n = this.size();
        ACell[] result = new ACell[n];
        AVector<Keyword> keys = this.getFormat().getKeys();
        for (int i = 0; i < n; ++i) {
            result[i] = this.get((ACell)keys.get(i));
        }
        return result;
    }

    @Override
    public boolean containsKey(ACell key) {
        return this.getFormat().containsKey(key);
    }

    @Override
    public boolean containsValue(ACell value) {
        return ((ASequence)this.values()).contains(value);
    }

    @Override
    public Set<Keyword> keySet() {
        return this.getFormat().keySet();
    }

    @Override
    public Set<Map.Entry<Keyword, ACell>> entrySet() {
        return this.toHashMap().entrySet();
    }

    @Override
    public AMap<Keyword, ACell> assoc(ACell key, ACell value) {
        return this.toHashMap().assoc(key, value);
    }

    public AMap<Keyword, ACell> dissoc(Keyword key) {
        if (!this.containsKey(key)) {
            return this;
        }
        return this.toHashMap().dissoc(key);
    }

    @Override
    public AMap<Keyword, ACell> dissoc(ACell key) {
        if (!this.containsKey(key)) {
            return this;
        }
        return this.toHashMap().dissoc(key);
    }

    @Override
    public MapEntry<Keyword, ACell> getKeyRefEntry(Ref<ACell> keyRef) {
        return this.getEntry(keyRef.getValue());
    }

    @Override
    protected void accumulateEntrySet(HashSet<Map.Entry<Keyword, ACell>> h) {
        for (long i = 0L; i < this.count; ++i) {
            h.add(this.entryAt(i));
        }
    }

    @Override
    protected void accumulateKeySet(HashSet<Keyword> h) {
        AVector<Keyword> keys = this.getFormat().getKeys();
        for (long i = 0L; i < this.count; ++i) {
            h.add(keys.get(i));
        }
    }

    @Override
    protected void accumulateValues(ArrayList<ACell> al) {
        this.toHashMap().accumulateValues(al);
    }

    @Override
    public void forEach(BiConsumer<? super Keyword, ? super ACell> action) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AMap<Keyword, ACell> assocEntry(MapEntry<Keyword, ACell> e) {
        return this.assoc((ACell)e.getKey(), (ACell)e.getValue());
    }

    @Override
    public MapEntry<Keyword, ACell> entryAt(long i) {
        if (i < 0L || i >= this.count) {
            throw new IndexOutOfBoundsException("Index:" + i);
        }
        Keyword k = this.getFormat().getKeys().get(i);
        return this.getEntry(k);
    }

    @Override
    public MapEntry<Keyword, ACell> getEntry(ACell k) {
        if (!this.containsKey(k)) {
            return null;
        }
        return MapEntry.create((Keyword)k, this.get(k));
    }

    @Override
    public <R> R reduceValues(BiFunction<? super R, ? super ACell, ? extends R> func, R initial) {
        int i = 0;
        while ((long)i < this.count) {
            initial = func.apply(initial, (ACell)this.entryAt(i).getValue());
            ++i;
        }
        return initial;
    }

    @Override
    public <R> R reduceEntries(BiFunction<? super R, MapEntry<Keyword, ACell>, ? extends R> func, R initial) {
        int i = 0;
        while ((long)i < this.count) {
            initial = func.apply(initial, this.entryAt(i));
            ++i;
        }
        return initial;
    }

    protected AHashMap<Keyword, ACell> toHashMap() {
        Object m = Maps.empty();
        int i = 0;
        while ((long)i < this.count) {
            m = ((AHashMap)m).assocEntry((MapEntry)this.entryAt(i));
            ++i;
        }
        return m;
    }

    @Override
    protected MapEntry<Keyword, ACell> getEntryByHash(Hash hash) {
        return this.toHashMap().getEntryByHash(hash);
    }

    @Override
    public AHashMap<Keyword, ACell> empty() {
        return Maps.empty();
    }

    public abstract RecordFormat getFormat();
}

