/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.crypto.Hashing;
import convex.core.data.ACell;
import convex.core.data.ACountable;
import convex.core.data.Blob;
import convex.core.data.BlobBuilder;
import convex.core.data.Hash;
import convex.core.data.Ref;
import convex.core.data.Strings;
import convex.core.data.prim.CVMLong;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.exceptions.InvalidDataException;
import convex.core.util.Utils;
import java.nio.ByteBuffer;
import java.security.MessageDigest;

public abstract class ABlob
extends ACountable<CVMLong>
implements Comparable<ABlob> {
    protected Hash contentHash = null;

    @Override
    public AType getType() {
        return Types.BLOB;
    }

    public abstract void getBytes(byte[] var1, int var2);

    @Override
    public abstract long count();

    @Override
    public CVMLong get(long ix) {
        return CVMLong.forByte(this.byteAt(ix));
    }

    @Override
    public Ref<CVMLong> getElementRef(long index) {
        return this.get(index).getRef();
    }

    public Blob empty() {
        return Blob.EMPTY;
    }

    public String toHexString() {
        return this.toHexString(Utils.checkedInt(this.count()) * 2);
    }

    public final String toHexString(int hexLength) {
        BlobBuilder bb = new BlobBuilder();
        this.appendHex(bb, hexLength);
        return bb.getCVMString().toString();
    }

    protected abstract boolean appendHex(BlobBuilder var1, long var2);

    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.getBytes());
    }

    public abstract ABlob slice(long var1, long var3);

    public ABlob slice(long start) {
        return this.slice(start, this.count());
    }

    public abstract Blob toFlatBlob();

    public abstract long commonHexPrefixLength(ABlob var1);

    public final Hash getContentHash() {
        if (this.contentHash == null) {
            this.contentHash = this.computeHash(Hashing.getDigest());
        }
        return this.contentHash;
    }

    public final Hash computeHash(MessageDigest digest) {
        this.updateDigest(digest);
        return Hash.wrap(digest.digest());
    }

    protected abstract void updateDigest(MessageDigest var1);

    public byte byteAt(long i) {
        if (i < 0L || i >= this.count()) {
            throw new IndexOutOfBoundsException("Index: " + i);
        }
        return this.getUnchecked(i);
    }

    public abstract byte getUnchecked(long var1);

    public int getHexDigit(long digitPos) {
        byte b = this.getUnchecked(digitPos >> 1);
        int shift = 4 * (1 - ((int)digitPos & 1));
        return b >> shift & 0xF;
    }

    public byte[] getBytes() {
        byte[] result = new byte[Utils.checkedInt(this.count())];
        this.getBytes(result, 0);
        return result;
    }

    public abstract ABlob append(ABlob var1);

    @Override
    public boolean equals(ACell o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ABlob)) {
            return false;
        }
        return this.equals((ABlob)o);
    }

    public abstract boolean equals(ABlob var1);

    @Override
    public abstract ABlob toCanonical();

    public abstract boolean equalsBytes(byte[] var1, int var2);

    @Override
    public int compareTo(ABlob b) {
        if (this == b) {
            return 0;
        }
        long alength = this.count();
        long blength = b.count();
        long compareLength = Math.min(alength, blength);
        for (long i = 0L; i < compareLength; ++i) {
            int c = (0xFF & this.getUnchecked(i)) - (0xFF & b.getUnchecked(i));
            if (c > 0) {
                return 1;
            }
            if (c >= 0) continue;
            return -1;
        }
        if (alength > compareLength) {
            return 1;
        }
        if (blength > compareLength) {
            return -1;
        }
        return 0;
    }

    public abstract ByteBuffer writeToBuffer(ByteBuffer var1);

    public abstract int writeToBuffer(byte[] var1, int var2);

    public abstract Blob getChunk(long var1);

    @Override
    public boolean print(BlobBuilder bb, long limit) {
        bb.append(Strings.HEX_PREFIX);
        return this.appendHex(bb, limit - bb.count());
    }

    public abstract ByteBuffer getByteBuffer();

    @Override
    public void validate() throws InvalidDataException {
        super.validate();
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.count() < 0L) {
            throw new InvalidDataException("Negative blob length", this);
        }
    }

    public abstract long hexMatchLength(ABlob var1, long var2, long var4);

    public boolean hexEquals(ABlob b) {
        long c = this.count();
        if (b.count() != c) {
            return false;
        }
        return this.hexMatchLength(b, 0L, c) == c;
    }

    public boolean hexEquals(ABlob b, long start, long length) {
        return this.hexMatchLength(b, start, length) == length;
    }

    public long hexLength() {
        return this.count() << 1;
    }

    @Override
    public abstract int encodeRaw(byte[] var1, int var2);

    public abstract long longValue();

    @Override
    public int hashCode() {
        return Long.hashCode(this.longValue());
    }

    public abstract long toExactLong();

    public boolean isRegularBlob() {
        return true;
    }

    @Override
    public boolean isCVMValue() {
        return true;
    }

    public abstract boolean equalsBytes(ABlob var1);

    public short shortAt(long i) {
        byte hi = this.byteAt(i);
        byte lo = this.byteAt(i + 1L);
        return (short)(hi << 8 | lo & 0xFF);
    }
}

