/*
 * Decompiled with CFR 0.152.
 */
package convex.core;

import convex.core.ErrorCodes;
import convex.core.data.ACell;
import convex.core.data.AMap;
import convex.core.data.ARecordGeneric;
import convex.core.data.AString;
import convex.core.data.AVector;
import convex.core.data.Address;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.core.data.Maps;
import convex.core.data.Strings;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.Context;
import convex.core.lang.impl.AExceptional;
import convex.core.lang.impl.ErrorValue;
import convex.core.lang.impl.RecordFormat;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeoutException;

public final class Result
extends ARecordGeneric {
    private static final RecordFormat RESULT_FORMAT = RecordFormat.of(Keywords.ID, Keywords.RESULT, Keywords.ERROR, Keywords.INFO);

    private Result(AVector<ACell> values) {
        super(RESULT_FORMAT, values);
    }

    private static Result buildFromVector(AVector<ACell> values) {
        return new Result(values);
    }

    public static Result create(CVMLong id, ACell value, ACell errorCode, AMap<Keyword, ACell> info) {
        return Result.buildFromVector(Vectors.of(id, value, errorCode, info));
    }

    public static Result create(CVMLong id, ACell value, ACell errorCode) {
        return Result.create(id, value, errorCode, null);
    }

    public static Result create(CVMLong id, ACell value) {
        return Result.create(id, value, null, null);
    }

    public ACell getID() {
        return this.values.get(0);
    }

    public <T extends ACell> T getValue() {
        return (T)this.values.get(1);
    }

    public AVector<AString> getTrace() {
        AMap<Keyword, ACell> info = this.getInfo();
        if (info instanceof AMap) {
            AMap<Keyword, ACell> m = info;
            return (AVector)m.get(Keywords.TRACE);
        }
        return null;
    }

    public AMap<Keyword, ACell> getInfo() {
        return (AMap)this.values.get(3);
    }

    public ACell getErrorCode() {
        return this.values.get(2);
    }

    @Override
    public AVector<ACell> values() {
        return this.values;
    }

    @Override
    protected Result withValues(AVector<ACell> newValues) {
        if (this.values == newValues) {
            return this;
        }
        return new Result(newValues);
    }

    @Override
    public void validate() throws InvalidDataException {
        super.validate();
        Object id = this.values.get(0);
        if (id != null && !(id instanceof CVMLong)) {
            throw new InvalidDataException("Result ID must be a CVM long value", this);
        }
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = -83;
        pos = this.values.encodeRaw(bs, pos);
        return pos;
    }

    public static Result read(ByteBuffer bb) throws BadFormatException {
        AVector<ACell> v = Vectors.read(bb);
        if ((long)v.size() != RESULT_FORMAT.count()) {
            throw new BadFormatException("Invalid number of fields for Result!");
        }
        return Result.buildFromVector(v);
    }

    public static Result read(Blob b, int pos) throws BadFormatException {
        int epos = pos;
        AVector<ACell> v = Vectors.read(b, epos);
        Result r = Result.buildFromVector(v);
        r.attachEncoding(b.slice(pos, epos += Format.getEncodingLength(v)));
        return r;
    }

    public boolean isError() {
        return this.getErrorCode() != null;
    }

    public static Result fromContext(CVMLong id, Context<?> ctx) {
        Object result = ctx.getValue();
        ACell errorCode = null;
        AMap<Keyword, ACell> info = null;
        if (result instanceof AExceptional) {
            AExceptional ex = (AExceptional)result;
            result = ex.getMessage();
            errorCode = ex.getCode();
            if (ex instanceof ErrorValue) {
                ErrorValue ev = (ErrorValue)ex;
                AVector trace = Vectors.create(ev.getTrace());
                Address address = ev.getAddress();
                info = (AMap<Keyword, ACell>)Maps.of(Keywords.TRACE, trace, Keywords.ADDRESS, address);
            }
        }
        return Result.create(id, (ACell)result, errorCode, info);
    }

    public static Result fromContext(Context<?> ctx) {
        return Result.fromContext(null, ctx);
    }

    public Result withID(ACell id) {
        return this.withValues((AVector)this.values.assoc(0L, id));
    }

    @Override
    public byte getTag() {
        return -83;
    }

    @Override
    public RecordFormat getFormat() {
        return RESULT_FORMAT;
    }

    public static Result fromException(Throwable e) {
        if (e instanceof TimeoutException) {
            return Result.create(null, ErrorCodes.TIMEOUT, Strings.create(e.getMessage()));
        }
        return Result.create(null, ErrorCodes.EXCEPTION, Strings.create(e.getMessage()));
    }
}

