/*
 * Decompiled with CFR 0.152.
 */
package convex.core.util;

import convex.core.exceptions.TODOException;
import convex.core.util.Utils;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class LatestUpdateQueue<E>
implements BlockingQueue<E> {
    private E item;

    @Override
    public synchronized boolean offer(E e) {
        if (e == null) {
            throw new IllegalArgumentException("Cannot offer a null value");
        }
        this.item = e;
        this.notify();
        return true;
    }

    @Override
    public synchronized E poll() {
        E result = this.item;
        this.item = null;
        return result;
    }

    @Override
    public synchronized E take() throws InterruptedException {
        if (this.item == null) {
            this.wait();
        }
        E result = this.item;
        this.item = null;
        return result;
    }

    @Override
    public synchronized E poll(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.item == null) {
            this.wait(unit.toMillis(timeout), 0);
        }
        return this.poll();
    }

    @Override
    public void clear() {
        this.item = null;
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    @Override
    public void put(E e) throws InterruptedException {
        boolean sent = this.offer(e);
        if (!sent) {
            throw new IllegalStateException("Offer shouldn't fail");
        }
    }

    @Override
    public E remove() {
        E result = this.poll();
        if (result == null) {
            throw new NoSuchElementException("Transfer queue empty");
        }
        return result;
    }

    @Override
    public E element() {
        E result = this.peek();
        if (result == null) {
            throw new NoSuchElementException("Transfer queue empty");
        }
        return result;
    }

    @Override
    public E peek() {
        E result = this.item;
        return result;
    }

    @Override
    public int size() {
        return this.item == null ? 0 : 1;
    }

    @Override
    public boolean isEmpty() {
        return this.item == null;
    }

    @Override
    public Iterator<E> iterator() {
        E r = this.peek();
        if (r == null) {
            return Collections.emptyIterator();
        }
        return Collections.singletonList(r).iterator();
    }

    @Override
    public Object[] toArray() {
        E r = this.peek();
        if (r == null) {
            return Utils.EMPTY_OBJECTS;
        }
        return new Object[]{r};
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new TODOException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new TODOException();
    }

    @Override
    public synchronized boolean addAll(Collection<? extends E> c) {
        for (E e : c) {
            this.offer(e);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new TODOException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new TODOException();
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        this.put(e);
        return true;
    }

    @Override
    public int remainingCapacity() {
        return 1;
    }

    @Override
    public boolean remove(Object o) {
        throw new TODOException();
    }

    @Override
    public boolean contains(Object o) {
        return Utils.equals(o, this.item);
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        E result = this.poll();
        if (result == null) {
            return 0;
        }
        c.add(result);
        return 1;
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        if (maxElements <= 0) {
            return 0;
        }
        return this.drainTo(c);
    }
}

