/*
 * Decompiled with CFR 0.152.
 */
package convex.core.lang.ops;

import convex.core.ErrorCodes;
import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.BlobBuilder;
import convex.core.data.Format;
import convex.core.data.IRefFunction;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.AOp;
import convex.core.lang.Context;
import java.nio.ByteBuffer;

public class Local<T extends ACell>
extends AOp<T> {
    private final long position;

    private Local(long position) {
        this.position = position;
    }

    public static final <R extends ACell> Local<R> create(long position) {
        if (position < 0L) {
            return null;
        }
        return new Local(position);
    }

    @Override
    public <R extends ACell> Context<T> execute(Context<R> context) {
        Context<ACell> ctx = context;
        AVector<ACell> env = ctx.getLocalBindings();
        long ec = env.count();
        if (this.position < 0L || this.position >= ec) {
            return ctx.withError(ErrorCodes.BOUNDS, "Bad position for Local: " + this.position);
        }
        ACell result = env.get(this.position);
        return ctx.withResult(15L, result);
    }

    @Override
    public byte opCode() {
        return 11;
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = Format.writeVLCLong(bs, pos, this.position);
        return pos;
    }

    public static <R extends ACell> Local<R> read(ByteBuffer bb) throws BadFormatException {
        long position = Format.readVLCLong(bb);
        Local<R> result = Local.create(position);
        if (result == null) {
            throw new BadFormatException("Can't create Local with position: " + position);
        }
        return result;
    }

    public static <R extends ACell> Local<R> read(Blob b, int pos) throws BadFormatException {
        int epos = pos + 2;
        long position = Format.readVLCLong(b, epos);
        epos += Format.getVLCLength(position);
        Local<R> result = Local.create(position);
        if (result == null) {
            throw new BadFormatException("Can't create Local with position: " + position);
        }
        result.attachEncoding(b.slice(pos, epos));
        return result;
    }

    @Override
    public Local<T> updateRefs(IRefFunction func) {
        return this;
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.position < 0L) {
            throw new InvalidDataException("Invalid Local position " + this.position, this);
        }
    }

    @Override
    public int getRefCount() {
        return 0;
    }

    @Override
    public boolean print(BlobBuilder bb, long limit) {
        bb.append(this.toString());
        return bb.check(limit);
    }

    @Override
    public String toString() {
        return "%" + this.position;
    }
}

