/*
 * Decompiled with CFR 0.152.
 */
package convex.core.lang.ops;

import convex.core.data.ACell;
import convex.core.data.ASequence;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.BlobBuilder;
import convex.core.data.Format;
import convex.core.data.Vectors;
import convex.core.exceptions.BadFormatException;
import convex.core.lang.AOp;
import convex.core.lang.Context;
import convex.core.lang.ops.AMultiOp;
import java.nio.ByteBuffer;

public class Do<T extends ACell>
extends AMultiOp<T> {
    public static final Do<?> EMPTY = Do.create(new AOp[0]);

    protected Do(AVector<AOp<ACell>> ops) {
        super(ops);
    }

    public static <T extends ACell> Do<T> create(AOp<?> ... ops) {
        return new Do<T>(Vectors.create(ops));
    }

    @Override
    protected Do<T> recreate(ASequence<AOp<ACell>> newOps) {
        if (this.ops == newOps) {
            return this;
        }
        return new Do<T>(newOps.toVector());
    }

    public static <T extends ACell> Do<T> create(ASequence<AOp<ACell>> ops) {
        return new Do<T>(ops.toVector());
    }

    @Override
    public <I extends ACell> Context<T> execute(Context<I> context) {
        AOp op;
        int n = this.ops.size();
        if (n == 0) {
            return context.withResult(5L, null);
        }
        Context ctx = context.consumeJuice(5L);
        if (ctx.isExceptional()) {
            return ctx;
        }
        for (int i = 0; i < n && !(ctx = ctx.execute(op = (AOp)this.ops.get(i))).isExceptional(); ++i) {
        }
        return ctx;
    }

    @Override
    public boolean print(BlobBuilder bb, long limit) {
        bb.append("(do");
        int len = this.ops.size();
        for (int i = 0; i < len; ++i) {
            bb.append(' ');
            if (((AOp)this.ops.get(i)).print(bb, limit)) continue;
            return false;
        }
        bb.append(')');
        return bb.check(limit);
    }

    @Override
    public byte opCode() {
        return 3;
    }

    public static <T extends ACell> Do<T> read(ByteBuffer b) throws BadFormatException {
        AVector ops = (AVector)Format.read(b);
        return Do.create(ops);
    }

    public static <T extends ACell> Do<T> read(Blob b, int pos) throws BadFormatException {
        int epos = pos + 2;
        AVector ops = (AVector)Format.read(b, epos);
        Do<T> result = Do.create(ops);
        result.attachEncoding(b.slice(pos, epos += Format.getEncodingLength(ops)));
        return result;
    }
}

