/*
 * Decompiled with CFR 0.152.
 */
package convex.core.lang.impl;

import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.BlobBuilder;
import convex.core.data.Format;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.AFn;
import convex.core.lang.Context;
import convex.core.lang.impl.AClosure;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class MultiFn<T extends ACell>
extends AClosure<T> {
    private final AVector<AClosure<T>> fns;
    private final int num;

    private MultiFn(AVector<AClosure<T>> fns, AVector<ACell> env) {
        super(env);
        this.fns = fns;
        this.num = fns.size();
    }

    private MultiFn(AVector<AClosure<T>> fns) {
        this(fns, Context.EMPTY_BINDINGS);
    }

    public static <R extends ACell> MultiFn<R> create(AVector<AClosure<R>> fns) {
        return new MultiFn(fns);
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public MultiFn<T> toCanonical() {
        return this;
    }

    @Override
    public boolean print(BlobBuilder bb, long limit) {
        bb.append("(fn ");
        if (!this.printInternal(bb, limit)) {
            return false;
        }
        bb.append(')');
        return bb.check(limit);
    }

    @Override
    public boolean printInternal(BlobBuilder bb, long limit) {
        for (long i = 0L; i < (long)this.num; ++i) {
            if (i > 0L) {
                bb.append(' ');
            }
            bb.append('(');
            if (!this.fns.get(i).printInternal(bb, limit)) {
                return false;
            }
            bb.append(')');
        }
        return bb.check(limit);
    }

    @Override
    public Context<T> invoke(Context<ACell> context, ACell[] args) {
        for (int i = 0; i < this.num; ++i) {
            AClosure fn = (AClosure)this.fns.get(i);
            if (!fn.supportsArgs(args)) continue;
            return fn.invoke(context, args);
        }
        return context.withArityError("No matching function arity found for arity " + args.length);
    }

    @Override
    public boolean hasArity(int n) {
        for (int i = 0; i < this.num; ++i) {
            AFn fn = (AFn)this.fns.get(i);
            if (!fn.hasArity(n)) continue;
            return true;
        }
        return false;
    }

    @Override
    public AFn<T> updateRefs(IRefFunction func) {
        ACell newFns = this.fns.updateRefs(func);
        if (this.fns == newFns) {
            return this;
        }
        return new MultiFn<T>(newFns);
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.num <= 0) {
            throw new InvalidDataException("MultiFn must contain at least one function", this);
        }
        this.fns.validateCell();
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = -53;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = this.fns.encode(bs, pos);
        return pos;
    }

    public static <T extends ACell> MultiFn<T> read(ByteBuffer bb) throws BadFormatException, BufferUnderflowException {
        AVector fns = (AVector)Format.read(bb);
        if (fns == null) {
            throw new BadFormatException("Null fns!");
        }
        return new MultiFn<T>(fns);
    }

    public static <T extends ACell> MultiFn<T> read(Blob b, int pos) throws BadFormatException {
        int epos = pos + 1;
        AVector fns = (AVector)Format.read(b, epos);
        if (fns == null) {
            throw new BadFormatException("Null fns!");
        }
        MultiFn<T> result = new MultiFn<T>(fns);
        result.attachEncoding(b.slice(pos, epos += Format.getEncodingLength(fns)));
        return result;
    }

    @Override
    public int estimatedEncodingSize() {
        return this.fns.estimatedEncodingSize() + 1;
    }

    @Override
    public int getRefCount() {
        return this.fns.getRefCount();
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        return this.fns.getRef(i);
    }

    @Override
    public <F extends AClosure<T>> F withEnvironment(AVector<ACell> env) {
        if (env == this.lexicalEnv) {
            return (F)this;
        }
        return (F)new MultiFn<T>(this.fns.map(fn -> fn.withEnvironment(env)), env);
    }
}

