/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.Blob;
import convex.core.data.BlobBuilder;
import convex.core.data.BlobTree;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.data.Strings;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.util.Errors;
import convex.core.util.Text;
import java.nio.ByteBuffer;

public class StringTree
extends AString {
    public static final int MINIMUM_LENGTH = 4097;
    public static final int MAX_ENCODING_LENGTH = 645;
    private final BlobTree data;

    private StringTree(BlobTree data) {
        super(data.count());
        this.data = data;
    }

    public static StringTree create(BlobTree b) {
        return new StringTree(b);
    }

    public static StringTree create(ABlob b) {
        return StringTree.create(BlobTree.create(b));
    }

    @Override
    public AString slice(long start, long end) {
        ABlob newData = this.data.slice(start, end);
        if (this.data == newData) {
            return this;
        }
        if (newData == null) {
            return null;
        }
        return Strings.create(newData);
    }

    @Override
    public void validateCell() throws InvalidDataException {
        this.data.validateCell();
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        return this.data.encodeRaw(bs, pos);
    }

    @Override
    public int writeRawData(byte[] bs, int pos) {
        return this.data.writeToBuffer(bs, pos);
    }

    public static StringTree read(long length, ByteBuffer bb) throws BadFormatException {
        BlobTree bt = BlobTree.read(bb, length);
        return new StringTree(bt);
    }

    public static StringTree read(long length, Blob b, int pos) throws BadFormatException {
        BlobTree bt = BlobTree.read(length, b, pos);
        StringTree result = new StringTree(bt);
        result.attachEncoding(bt.getEncoding());
        bt.attachEncoding(null);
        return result;
    }

    @Override
    public int estimatedEncodingSize() {
        return this.data.estimatedEncodingSize();
    }

    @Override
    public boolean isCanonical() {
        return this.data.isCanonical();
    }

    @Override
    public final boolean isCVMValue() {
        return true;
    }

    @Override
    public int getRefCount() {
        return this.data.getRefCount();
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        return this.data.getRef(i);
    }

    @Override
    public StringTree updateRefs(IRefFunction func) {
        BlobTree bt2 = this.data.updateRefs(func);
        if (bt2 == this.data) {
            return this;
        }
        return new StringTree(bt2);
    }

    @Override
    public StringTree toCanonical() {
        return this;
    }

    @Override
    protected byte byteAt(long i) {
        if (i < 0L || i >= this.length) {
            return -1;
        }
        return this.data.byteAt(i);
    }

    @Override
    public int intAt(long i) {
        return super.intAt(i);
    }

    @Override
    public int compareTo(AString o) {
        return this.data.compareTo(o.toBlob());
    }

    @Override
    public BlobTree toBlob() {
        return this.data;
    }

    @Override
    protected void writeToBuffer(ByteBuffer bb) {
        this.data.writeToBuffer(bb);
    }

    @Override
    protected void printEscaped(BlobBuilder sb, long start, long end) {
        long n = this.count();
        if (start < 0L || start > end || end > n) {
            throw new IllegalArgumentException(Errors.badRange(start, end));
        }
        for (long i = start; i < end; ++i) {
            byte b = this.data.getUnchecked(i);
            Text.writeEscapedByte(sb, b);
        }
    }
}

