/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.crypto.AKeyPair;
import convex.core.crypto.ASignature;
import convex.core.crypto.Ed25519Signature;
import convex.core.crypto.Providers;
import convex.core.data.ACell;
import convex.core.data.ARecord;
import convex.core.data.AccountKey;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.IRefFunction;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.core.data.Ref;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.BadSignatureException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.impl.RecordFormat;
import convex.core.transactions.ATransaction;
import java.nio.ByteBuffer;

public final class SignedData<T extends ACell>
extends ARecord {
    private final AccountKey publicKey;
    private final ASignature signature;
    private final Ref<T> valueRef;
    private static final Keyword[] KEYS = new Keyword[]{Keywords.PUBLIC_KEY, Keywords.SIGNATURE, Keywords.VALUE};
    private static final RecordFormat FORMAT = RecordFormat.of(KEYS);

    private SignedData(Ref<T> refToValue, AccountKey address, ASignature sig) {
        super(FORMAT.count());
        this.valueRef = refToValue;
        this.publicKey = address;
        this.signature = sig;
    }

    public static <T extends ACell> SignedData<T> createWithRef(AKeyPair keyPair, Ref<T> ref) {
        ASignature sig = keyPair.sign(ref.getHash());
        SignedData<T> sd = new SignedData<T>(ref, keyPair.getAccountKey(), sig);
        sd.markValidated();
        return sd;
    }

    private void markValidated() {
        Ref ref = this.getRef();
        int flags = ref.getFlags();
        if ((flags & 0x40) != 0) {
            return;
        }
        ref.setFlags(flags | 0x40);
    }

    private void markBadSignature() {
        Ref ref = this.getRef();
        int flags = ref.getFlags();
        if ((flags & 0x80) != 0) {
            return;
        }
        ref.setFlags(flags | 0x80);
    }

    public static <T extends ACell> SignedData<T> create(AKeyPair keyPair, T value2) {
        return SignedData.createWithRef(keyPair, Ref.get(value2));
    }

    public static <T extends ACell> SignedData<T> create(AccountKey address, ASignature sig, Ref<T> ref) {
        return new SignedData<T>(ref, address, sig);
    }

    public static SignedData<ATransaction> create(AKeyPair kp, ASignature sig, Ref<ATransaction> ref) {
        return SignedData.create(kp.getAccountKey(), sig, ref);
    }

    public T getValue() {
        return this.valueRef.getValue();
    }

    public AccountKey getAccountKey() {
        return this.publicKey;
    }

    public ASignature getSignature() {
        return this.signature;
    }

    @Override
    public ACell get(ACell key) {
        if (Keywords.PUBLIC_KEY.equals(key)) {
            return this.publicKey;
        }
        if (Keywords.SIGNATURE.equals(key)) {
            return this.signature;
        }
        if (Keywords.VALUE.equals(key)) {
            return this.getValue();
        }
        return null;
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = -112;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = this.publicKey.writeToBuffer(bs, pos);
        pos = this.signature.writeToBuffer(bs, pos);
        pos = this.valueRef.encode(bs, pos);
        return pos;
    }

    @Override
    public int estimatedEncodingSize() {
        return 237;
    }

    public static <T extends ACell> SignedData<T> read(ByteBuffer data) throws BadFormatException {
        AccountKey address = AccountKey.readRaw(data);
        Ed25519Signature sig = Ed25519Signature.readRaw(data);
        Ref value = Format.readRef(data);
        return SignedData.create(address, (ASignature)sig, value);
    }

    public static <T extends ACell> SignedData<T> read(Blob b, int pos) throws BadFormatException {
        int epos = pos + 1;
        AccountKey address = AccountKey.readRaw(b, epos);
        ASignature sig = Ed25519Signature.readRaw(b, epos += 32);
        Ref value = Format.readRef(b, epos += 64);
        epos = (int)((long)epos + value.getEncodingLength());
        SignedData result = SignedData.create(address, sig, value);
        result.attachEncoding(b.slice(pos, epos));
        return result;
    }

    public boolean checkSignature() {
        Ref sigRef = this.getRef();
        int flags = sigRef.getFlags();
        if ((flags & 0x80) != 0) {
            return false;
        }
        if ((flags & 0x40) != 0) {
            return true;
        }
        Hash hash = this.valueRef.getHash();
        boolean check = Providers.verify(this.signature, hash, this.publicKey);
        if (check) {
            this.markValidated();
        } else {
            this.markBadSignature();
        }
        return check;
    }

    public boolean isSignatureChecked() {
        Ref sigRef = this.getRef();
        int flags = sigRef.getFlags();
        return (flags & 0xC0) != 0;
    }

    public void validateSignature() throws BadSignatureException {
        if (!this.checkSignature()) {
            throw new BadSignatureException("Signature not valid!", this);
        }
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public final boolean isCVMValue() {
        return false;
    }

    @Override
    public final int getRefCount() {
        return 1;
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        if (i != 0) {
            throw new IndexOutOfBoundsException("Illegal SignedData ref index: " + i);
        }
        return this.valueRef;
    }

    @Override
    public SignedData<T> updateRefs(IRefFunction func) {
        Ref<?> newValueRef = func.apply(this.valueRef);
        if (this.valueRef == newValueRef) {
            return this;
        }
        SignedData newSD = new SignedData(newValueRef, this.publicKey, this.signature);
        Ref sdr = newSD.getRef();
        sdr.setFlags(Ref.mergeFlags(sdr.getFlags(), this.getRef().getFlags()));
        newSD.attachEncoding(this.encoding);
        return newSD;
    }

    @Override
    public void validate() throws InvalidDataException {
        super.validate();
    }

    @Override
    public void validateCell() throws InvalidDataException {
        this.publicKey.validate();
        this.signature.validate();
        this.valueRef.validate();
    }

    public Ref<T> getValueRef() {
        return this.valueRef;
    }

    @Override
    public boolean isEmbedded() {
        return false;
    }

    @Override
    public byte getTag() {
        return -112;
    }

    @Override
    public RecordFormat getFormat() {
        return FORMAT;
    }
}

