/*
 * Decompiled with CFR 0.152.
 */
package convex.core.lang.reader;

import convex.core.data.ACell;
import convex.core.data.AHashMap;
import convex.core.data.AMap;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.core.data.Maps;
import convex.core.data.Symbol;
import convex.core.data.Syntax;
import convex.core.data.prim.CVMChar;
import convex.core.data.prim.CVMDouble;
import convex.core.lang.Symbols;
import java.util.HashMap;
import org.apache.commons.text.StringEscapeUtils;

public class ReaderUtils {
    private static final HashMap<String, CVMChar> specialCharacters = Maps.hashMapOf("newline", CVMChar.create(10L), "space", CVMChar.create(32L), "tab", CVMChar.create(9L), "formfeed", CVMChar.create(12L), "backspace", CVMChar.create(8L), "return", CVMChar.create(13L));
    private static final HashMap<String, Symbol> quotingSymbols = Maps.hashMapOf("'", Symbols.QUOTE, "`", Symbols.QUASIQUOTE, "~", Symbols.UNQUOTE, "~@", Symbols.UNQUOTE_SPLICING);
    private static final HashMap<String, ACell> specialLiterals = Maps.hashMapOf("##NaN", CVMDouble.NaN, "##Inf", CVMDouble.POSITIVE_INFINITY, "##-Inf", CVMDouble.NEGATIVE_INFINITY);

    public static AHashMap<ACell, ACell> interpretMetadata(ACell metaNode) {
        Object val = Syntax.unwrapAll(metaNode);
        if (val instanceof AMap) {
            return (AHashMap)val;
        }
        if (val instanceof Keyword) {
            return Maps.of(val, Boolean.TRUE);
        }
        return Maps.of(Keywords.TAG, val);
    }

    public static CVMChar specialCharacter(String s) {
        return specialCharacters.get(s);
    }

    public static Symbol getQuotingSymbol(String s) {
        return quotingSymbols.get(s);
    }

    public static String unescapeString(String s) {
        return StringEscapeUtils.unescapeJava((String)s);
    }

    public static String escapeString(String s) {
        return StringEscapeUtils.escapeJava((String)s);
    }

    public static ACell specialLiteral(String s) {
        return specialLiterals.get(s);
    }
}

