/*
 * Decompiled with CFR 0.152.
 */
package convex.core.transactions;

import convex.core.data.ACell;
import convex.core.data.Address;
import convex.core.data.Format;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.Context;
import convex.core.lang.RT;
import convex.core.transactions.ATransaction;
import java.nio.ByteBuffer;

public class Transfer
extends ATransaction {
    public static final long TRANSFER_JUICE = 100L;
    protected final Address target;
    protected final long amount;

    protected Transfer(Address address, long nonce, Address target, long amount) {
        super(address, nonce);
        this.target = target;
        this.amount = amount;
    }

    public static Transfer create(Address address, long nonce, Address target, long amount) {
        return new Transfer(address, nonce, target, amount);
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = -47;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = super.encodeRaw(bs, pos);
        pos = this.target.encodeRaw(bs, pos);
        pos = Format.writeVLCLong(bs, pos, this.amount);
        return pos;
    }

    public static Transfer read(ByteBuffer bb) throws BadFormatException {
        Address address = Address.create(Format.readVLCLong(bb));
        long nonce = Format.readVLCLong(bb);
        Address target = Address.readRaw(bb);
        long amount = Format.readVLCLong(bb);
        if (!RT.isValidAmount(amount)) {
            throw new BadFormatException("Invalid amount: " + amount);
        }
        return Transfer.create(address, nonce, target, amount);
    }

    @Override
    public <T extends ACell> Context<T> apply(Context<?> ctx) {
        if (!(ctx = ctx.consumeJuice(100L)).isExceptional()) {
            ctx = ctx.transfer(this.target, this.amount);
        }
        return ctx;
    }

    @Override
    public int estimatedEncodingSize() {
        return 56;
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public void print(StringBuilder sb) {
        sb.append("{");
        sb.append(":transfer-to ");
        this.target.print(sb);
        sb.append(',');
        sb.append(":amount " + this.amount);
        sb.append('}');
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.amount < 0L || this.amount > 1000000000000000000L) {
            throw new InvalidDataException("Invalid amount", this);
        }
        if (this.target == null) {
            throw new InvalidDataException("Null Address", this);
        }
    }

    public Address getTarget() {
        return this.target;
    }

    public long getAmount() {
        return this.amount;
    }

    @Override
    public Long getMaxJuice() {
        return 100L;
    }

    @Override
    public int getRefCount() {
        return 0;
    }

    @Override
    public Transfer withSequence(long newSequence) {
        if (newSequence == this.sequence) {
            return this;
        }
        return Transfer.create(this.address, newSequence, this.target, this.amount);
    }

    @Override
    public Transfer withAddress(Address newAddress) {
        if (newAddress == this.address) {
            return this;
        }
        return Transfer.create(newAddress, this.sequence, this.target, this.amount);
    }

    @Override
    public byte getTag() {
        return -47;
    }
}

