/*
 * Decompiled with CFR 0.152.
 */
package convex.core.store;

import convex.core.store.AStore;
import etch.EtchStore;

public class Stores {
    private static AStore defaultStore = null;
    private static AStore globalStore = null;
    private static final ThreadLocal<AStore> currentStore = new ThreadLocal<AStore>(){

        @Override
        protected AStore initialValue() {
            return Stores.getGlobalStore();
        }
    };

    public static AStore current() {
        return currentStore.get();
    }

    public static void setCurrent(AStore store) {
        currentStore.set(store);
    }

    private static synchronized AStore getDefaultStore() {
        if (defaultStore == null) {
            defaultStore = EtchStore.createTemp("convex-db");
        }
        return defaultStore;
    }

    public static AStore getGlobalStore() {
        if (globalStore == null) {
            globalStore = Stores.getDefaultStore();
        }
        return globalStore;
    }

    public static void setGlobalStore(EtchStore store) {
        if (globalStore == null) {
            throw new IllegalArgumentException("Cannot set global store to null)");
        }
        globalStore = store;
    }
}

