/*
 * Decompiled with CFR 0.152.
 */
package convex.core.lang.impl;

import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.Strings;
import convex.core.lang.impl.AExceptional;
import java.util.ArrayList;
import java.util.List;

public class ErrorValue
extends AExceptional {
    private final ACell code;
    private final ACell message;
    private final ArrayList<AString> trace = new ArrayList();
    private ACell log;

    private ErrorValue(ACell code, ACell message) {
        if (code == null) {
            throw new IllegalArgumentException("Error code must not be null");
        }
        this.code = code;
        this.message = message;
    }

    public static ErrorValue create(ACell code) {
        return new ErrorValue(code, null);
    }

    public static ErrorValue create(ACell code, AString message) {
        return new ErrorValue(code, message);
    }

    public static ErrorValue createRaw(ACell code, ACell message) {
        return new ErrorValue(code, message);
    }

    public static ErrorValue create(ACell code, String message) {
        return new ErrorValue(code, Strings.create(message));
    }

    @Override
    public ACell getCode() {
        return this.code;
    }

    public void addTrace(String traceMessage) {
        this.trace.add(Strings.create(traceMessage));
    }

    public void addLog(ACell log) {
        this.log = log;
    }

    @Override
    public ACell getMessage() {
        return this.message;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ErrorValue[" + this.code + "]" + (String)(this.message == null ? "" : " : " + this.message));
        if (this.trace != null) {
            for (AString o : this.trace) {
                sb.append("\n");
                sb.append(((Object)o).toString());
            }
        }
        return sb.toString();
    }

    public List<AString> getTrace() {
        return this.trace;
    }

    public ACell getLog() {
        return this.log;
    }
}

