/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.ACollection;
import convex.core.data.ADataStructure;
import convex.core.data.AHashSet;
import convex.core.data.AMap;
import convex.core.data.ASequence;
import convex.core.data.ASet;
import convex.core.data.Format;
import convex.core.data.Ref;
import convex.core.data.SetLeaf;
import convex.core.data.SetTree;
import convex.core.exceptions.BadFormatException;
import convex.core.lang.RT;
import convex.core.util.Utils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;

public class Sets {
    static final Ref<?>[] EMPTY_ENTRIES = new Ref[0];
    static final SetLeaf EMPTY = new SetLeaf(EMPTY_ENTRIES);
    public static final Ref<SetLeaf> EMPTY_REF;

    public static <T extends ACell> SetLeaf<T> empty() {
        return EMPTY;
    }

    public static <T extends ACell> Ref<SetLeaf<T>> emptyRef() {
        return EMPTY_REF;
    }

    @SafeVarargs
    public static <T extends ACell> ASet<T> of(Object ... elements) {
        int n = elements.length;
        ACollection result = Sets.empty();
        for (int i = 0; i < n; ++i) {
            result = ((ASet)result).conj((ACell)RT.cvm(elements[i]));
        }
        return result;
    }

    @SafeVarargs
    public static <T extends ACell> ASet<T> of(ACell ... elements) {
        int n = elements.length;
        ACollection result = Sets.empty();
        for (int i = 0; i < n; ++i) {
            result = ((ASet)result).conj(elements[i]);
        }
        return result;
    }

    public static <T extends ACell> ASet<T> create(ADataStructure<T> source) {
        if (source instanceof ASet) {
            return (ASet)source;
        }
        if (source instanceof AMap) {
            ASequence seq = RT.sequence(source);
            return Sets.create(seq);
        }
        if (source instanceof ACollection) {
            return Sets.fromCollection((Collection)((Object)source));
        }
        throw new IllegalArgumentException("Unexpected type!" + Utils.getClass(source));
    }

    public static <T extends ACell> ASet<T> fromCollection(Collection<T> source) {
        return Sets.of(source.toArray());
    }

    public static <T extends ACell> ASet<T> read(ByteBuffer bb) throws BadFormatException {
        long count = Format.readVLCLong(bb);
        if (count <= 16L) {
            return SetLeaf.read(bb, count);
        }
        return SetTree.read(bb, count);
    }

    public static <T extends ACell> AHashSet<T> createWithShift(int shift, ArrayList<Ref<T>> values) {
        AHashSet result = Sets.empty();
        for (Ref<T> v : values) {
            result = ((AHashSet)result).includeRef(v, shift);
        }
        return result;
    }

    static {
        EMPTY.getRef().setFlags(85);
        EMPTY_REF = EMPTY.getRef();
    }
}

