/*
 * Decompiled with CFR 0.152.
 */
package convex.core.crypto;

import convex.core.crypto.AKeyPair;
import convex.core.crypto.Ed25519KeyPair;
import convex.core.crypto.Providers;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.x509.X509V3CertificateGenerator;

public class PFXTools {
    public static final String KEYSTORE_TYPE = "PKCS12";
    public static final String CERTIFICATE_ALGORITHM = "RSA";

    public static KeyStore createStore(File keyFile, String passPhrase) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore ks = KeyStore.getInstance(KEYSTORE_TYPE);
        Providers.init();
        char[] pwdArray = passPhrase == null ? null : passPhrase.toCharArray();
        ks.load(null, pwdArray);
        try (FileOutputStream fos = new FileOutputStream(keyFile);){
            ks.store(fos, pwdArray);
        }
        return ks;
    }

    public static KeyStore loadStore(File keyFile, String passPhrase) throws IOException, GeneralSecurityException {
        Providers.init();
        KeyStore ks = KeyStore.getInstance(KEYSTORE_TYPE);
        char[] pwdArray = passPhrase == null ? null : passPhrase.toCharArray();
        try (FileInputStream fis = new FileInputStream(keyFile);){
            ks.load(fis, pwdArray);
        }
        return ks;
    }

    public static KeyStore saveStore(KeyStore ks, File keyFile, String passPhrase) throws GeneralSecurityException, IOException {
        char[] pwdArray = passPhrase == null ? null : passPhrase.toCharArray();
        try (FileOutputStream fos = new FileOutputStream(keyFile);){
            ks.store(fos, pwdArray);
        }
        return ks;
    }

    public static Certificate createSelfSignedCertificate(AKeyPair kpToSign) throws GeneralSecurityException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(CERTIFICATE_ALGORITHM);
        KeyPair kp = keyPairGenerator.generateKeyPair();
        X509V3CertificateGenerator v3CertGen = new X509V3CertificateGenerator();
        String domainName = "convex.world";
        v3CertGen.setSerialNumber(BigInteger.valueOf(new SecureRandom().nextInt(Integer.MAX_VALUE)));
        v3CertGen.setIssuerDN((X509Name)new X509Principal("CN=" + domainName + ", OU=None, O=None L=None, C=None"));
        v3CertGen.setNotBefore(new Date(System.currentTimeMillis() - 2592000000L));
        v3CertGen.setNotAfter(new Date(System.currentTimeMillis() + 315360000000L));
        v3CertGen.setSubjectDN((X509Name)new X509Principal("CN=" + domainName + ", OU=None, O=None L=None, C=None"));
        v3CertGen.setPublicKey(kpToSign.getPublic());
        v3CertGen.setSignatureAlgorithm("SHA256WithRSAEncryption");
        X509Certificate cert = v3CertGen.generateX509Certificate(kp.getPrivate());
        return cert;
    }

    public static KeyStore saveKey(KeyStore ks, AKeyPair kp, String passPhrase) throws IOException, GeneralSecurityException {
        if (passPhrase == null) {
            throw new IllegalArgumentException("Password is mandatory for private key");
        }
        char[] pwdArray = passPhrase.toCharArray();
        String alias = kp.getAccountKey().toHexString();
        Certificate cert = PFXTools.createSelfSignedCertificate(kp);
        ks.setKeyEntry(alias, kp.getPrivate(), pwdArray, new Certificate[]{cert});
        return ks;
    }

    public static AKeyPair getKeyPair(KeyStore ks, String alias, String passPhrase) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException {
        char[] pwdArray = passPhrase.toCharArray();
        Certificate cert = ks.getCertificate(alias);
        Key sk = ks.getKey(alias, pwdArray);
        return Ed25519KeyPair.create(cert.getPublicKey(), (PrivateKey)sk);
    }
}

