/*
 * Decompiled with CFR 0.152.
 */
package etch;

import convex.core.data.ACell;
import convex.core.data.Hash;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.store.AStore;
import convex.core.util.Utils;
import etch.Etch;
import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtchStore
extends AStore {
    private static final Logger log = LoggerFactory.getLogger((String)EtchStore.class.getName());
    private Etch etch;

    public EtchStore(Etch etch) {
        this.etch = etch;
        etch.setStore(this);
    }

    public static EtchStore create(File file) throws IOException {
        Etch etch = Etch.create(file);
        return new EtchStore(etch);
    }

    public static EtchStore createTemp(String prefix) {
        try {
            Etch etch = Etch.createTempEtch(prefix);
            return new EtchStore(etch);
        }
        catch (IOException e) {
            throw (RuntimeException)Utils.sneakyThrow(e);
        }
    }

    public static EtchStore createTemp() {
        try {
            Etch etch = Etch.createTempEtch();
            return new EtchStore(etch);
        }
        catch (IOException e) {
            throw (RuntimeException)Utils.sneakyThrow(e);
        }
    }

    @Override
    public <T extends ACell> Ref<T> refForHash(Hash hash) {
        try {
            Ref<ACell> existing = this.etch.read(hash);
            return existing;
        }
        catch (IOException e) {
            throw new Error("IO exception from Etch", e);
        }
    }

    @Override
    public <T extends ACell> Ref<T> storeRef(Ref<T> ref, int status, Consumer<Ref<ACell>> noveltyHandler) {
        return this.storeRef(ref, noveltyHandler, status, false);
    }

    @Override
    public <T extends ACell> Ref<T> storeTopRef(Ref<T> ref, int status, Consumer<Ref<ACell>> noveltyHandler) {
        return this.storeRef(ref, noveltyHandler, status, true);
    }

    public <T extends ACell> Ref<T> storeRef(Ref<T> ref, Consumer<Ref<ACell>> noveltyHandler, int requiredStatus, boolean topLevel) {
        IRefFunction func;
        ACell newObject;
        Ref<T> existing;
        if (ref.getStatus() >= requiredStatus) {
            return ref;
        }
        T cell = ref.getValue();
        if (cell == null) {
            return Ref.NULL_VALUE;
        }
        boolean embedded = ((ACell)cell).isEmbedded();
        Hash hash = null;
        if (!embedded && (existing = this.refForHash(hash = ref.getHash())) != null && existing.getStatus() >= requiredStatus) {
            ((ACell)cell).attachRef(existing);
            return existing;
        }
        if (requiredStatus > 1 && ((ACell)cell).getRefCount() > 0 && cell != (newObject = ((ACell)cell).updateRefs(func = r -> this.storeRef(r, noveltyHandler, requiredStatus, false)))) {
            ref = ref.withValue(newObject);
        }
        if (topLevel || !embedded) {
            Ref<ACell> result;
            Hash fHash;
            Hash hash2 = fHash = hash != null ? hash : ref.getHash();
            if (log.isTraceEnabled()) {
                log.trace("Etch persisting at status=" + requiredStatus + " hash = 0x" + fHash.toHexString() + " ref of class " + Utils.getClassName(cell) + " with store " + this);
            }
            try {
                ref = ref.withMinimumStatus(requiredStatus);
                result = this.etch.write(fHash, ref);
            }
            catch (IOException e) {
                throw (RuntimeException)Utils.sneakyThrow(e);
            }
            if (noveltyHandler != null) {
                noveltyHandler.accept(result);
            }
            return result;
        }
        return ref.withMinimumStatus(requiredStatus);
    }

    public String toString() {
        return "EtchStore at: " + this.etch.getFile().getName();
    }

    public String getFileName() {
        return this.etch.getFile().toString();
    }

    @Override
    public void close() {
        this.etch.close();
    }

    public void flush() throws IOException {
        this.etch.flush();
    }

    public File getFile() {
        return this.etch.getFile();
    }

    @Override
    public Hash getRootHash() throws IOException {
        return this.etch.getRootHash();
    }

    @Override
    public void setRootHash(Hash h) throws IOException {
        this.etch.setRootHash(h);
    }

    public Etch getEtch() {
        return this.etch;
    }
}

