/*
 * Decompiled with CFR 0.152.
 */
package convex.core.store;

import convex.core.store.AStore;
import etch.EtchStore;
import java.util.logging.Level;

public class Stores {
    private static AStore defaultStore = null;
    private static AStore globalStore = null;
    private static final ThreadLocal<AStore> currentStore = new ThreadLocal<AStore>(){

        @Override
        protected AStore initialValue() {
            return Stores.getGlobalStore();
        }
    };
    public static final Level PERSIST_LOG_LEVEL = Level.FINE;
    public static final Level STORE_LOG_LEVEL = Level.FINE;

    public static AStore current() {
        return currentStore.get();
    }

    public static void setCurrent(AStore store) {
        currentStore.set(store);
    }

    public static AStore getDefaultStore() {
        if (defaultStore == null) {
            defaultStore = EtchStore.createTemp("convex-db");
        }
        return defaultStore;
    }

    public static AStore getGlobalStore() {
        if (globalStore == null) {
            globalStore = Stores.getDefaultStore();
        }
        return globalStore;
    }

    public static void setGlobalStore(EtchStore store) {
        globalStore = store;
    }
}

