/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ABlob;
import convex.core.data.ABlobMap;
import convex.core.data.ACell;
import convex.core.data.ADataStructure;
import convex.core.data.AMap;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.IRefFunction;
import convex.core.data.MapEntry;
import convex.core.data.Ref;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.RT;
import convex.core.util.Bits;
import convex.core.util.Errors;
import convex.core.util.Utils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Predicate;

public class BlobMap<K extends ABlob, V extends ACell>
extends ABlobMap<K, V> {
    private static final Ref<BlobMap>[] EMPTY_CHILDREN = new Ref[0];
    public static final BlobMap<ABlob, ACell> EMPTY = new BlobMap(0L, 0L, null, EMPTY_CHILDREN, 0, 0L);
    private final Ref<BlobMap<K, V>>[] children;
    private final MapEntry<K, V> entry;
    private final short mask;
    private final long depth;
    private final long prefixLength;

    protected BlobMap(long depth, long prefixLength, MapEntry<K, V> entry, Ref<BlobMap>[] entries, short mask, long count) {
        super(count);
        this.depth = depth;
        this.prefixLength = prefixLength;
        this.entry = entry;
        int cn = Utils.bitCount(mask);
        if (cn != entries.length) {
            throw new IllegalArgumentException("Illegal mask: " + Utils.toHexString(mask) + " for given number of children: " + cn);
        }
        this.children = entries;
        this.mask = mask;
    }

    public static <K extends ABlob, V extends ACell> BlobMap<K, V> create(MapEntry<K, V> me) {
        Object k = me.getKey();
        if (!(k instanceof ABlob)) {
            return null;
        }
        long hexLength = ((ABlob)k).hexLength();
        return new BlobMap<K, V>(0L, hexLength, me, EMPTY_CHILDREN, 0, 1L);
    }

    private static <K extends ABlob, V extends ACell> BlobMap<K, V> createAtDepth(MapEntry<K, V> me, long depth) {
        Blob prefix = ((ABlob)me.getKey()).toBlob();
        long hexLength = prefix.hexLength();
        if (depth > hexLength) {
            throw new IllegalArgumentException("Depth " + depth + " too deep for key with hexLength: " + hexLength);
        }
        return new BlobMap<K, V>(depth, hexLength - depth, me, EMPTY_CHILDREN, 0, 1L);
    }

    public static <K extends ABlob, V extends ACell> BlobMap<K, V> create(K k, V v) {
        MapEntry<K, V> me = MapEntry.create(k, v);
        long hexLength = k.hexLength();
        return new BlobMap<K, V>(0L, hexLength, me, EMPTY_CHILDREN, 0, 1L);
    }

    public static <K extends ABlob, V extends ACell> BlobMap<K, V> of(Object k, Object v) {
        return BlobMap.create((ABlob)RT.cvm(k), RT.cvm(v));
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public final boolean isCVMValue() {
        return this.depth == 0L;
    }

    @Override
    public BlobMap<K, V> updateRefs(IRefFunction func) {
        AVector newEntry = this.entry == null ? null : this.entry.updateRefs(func);
        Ref<BlobMap<K, V>>[] newChildren = Ref.updateRefs(this.children, func);
        if (this.entry == newEntry && this.children == newChildren) {
            return this;
        }
        return new BlobMap<K, V>(this.depth, this.prefixLength, newEntry, (Ref<BlobMap>[])newChildren, this.mask, this.count);
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.entry != null && Utils.equals(this.entry.getValue(), value)) {
            return true;
        }
        int i = 0;
        while ((long)i < this.count) {
            if (this.children[i].getValue().containsValue(value)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public V get(ABlob key) {
        MapEntry<K, V> me = this.getEntry(key);
        if (me == null) {
            return null;
        }
        return (V)me.getValue();
    }

    @Override
    public MapEntry<K, V> getEntry(ABlob key) {
        long pl;
        long kl = key.hexLength();
        if (kl < (pl = this.depth + this.prefixLength)) {
            return null;
        }
        if (kl == pl) {
            if (this.entry != null && key.equalsBytes((ABlob)this.entry.getKey())) {
                return this.entry;
            }
            return null;
        }
        int digit = key.getHexDigit(pl);
        BlobMap<K, V> cc = this.getChild(digit);
        if (cc == null) {
            return null;
        }
        return cc.getEntry(key);
    }

    private BlobMap<K, V> getChild(int digit) {
        int i = Bits.indexForDigit(digit, this.mask);
        if (i < 0) {
            return null;
        }
        return this.children[i].getValue();
    }

    @Override
    public int getRefCount() {
        return (this.entry == null ? 0 : this.entry.getRefCount()) + this.children.length;
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        int cl;
        if (this.entry != null) {
            int erc = this.entry.getRefCount();
            if (i < erc) {
                return this.entry.getRef(i);
            }
            i -= erc;
        }
        if (i < (cl = this.children.length)) {
            return this.children[i];
        }
        throw new IndexOutOfBoundsException("No ref for index:" + i);
    }

    @Override
    public BlobMap<K, V> assoc(ACell key, ACell value) {
        if (!(key instanceof ABlob)) {
            return null;
        }
        return this.assocEntry((MapEntry)MapEntry.create((ABlob)key, value));
    }

    @Override
    public BlobMap<K, V> dissoc(ABlob k) {
        ABlobMap newChild;
        if (this.count <= 1L) {
            if (this.count == 0L) {
                return this;
            }
            if (((ABlob)this.entry.getKey()).equalsBytes(k)) {
                return this.depth == 0L ? this.empty() : null;
            }
            return this;
        }
        long pDepth = this.depth + this.prefixLength;
        long kl = k.hexLength();
        if (kl < pDepth) {
            return this;
        }
        if (kl == pDepth) {
            if (this.entry == null) {
                return this;
            }
            if (!k.equalsBytes((ABlob)this.entry.getKey())) {
                return this;
            }
            if (this.children.length == 1) {
                BlobMap<K, V> c = this.children[0].getValue();
                return new BlobMap<K, V>(this.depth, c.depth + c.prefixLength - this.depth, c.entry, c.children, c.mask, this.count - 1L);
            }
            return new BlobMap<K, V>(this.depth, this.prefixLength, null, this.children, this.mask, this.count - 1L);
        }
        int digit = k.getHexDigit(pDepth);
        int childIndex = Bits.indexForDigit(digit, this.mask);
        if (childIndex < 0) {
            return this;
        }
        BlobMap<K, V> oldChild = this.children[childIndex].getValue();
        ADataStructure r = this.withChild(digit, oldChild, (BlobMap<K, V>)(newChild = oldChild.dissoc(k)));
        if (r == null && this.depth == 0L) {
            r = this.empty();
        }
        return r;
    }

    private ABlob getPrefix() {
        if (this.entry != null) {
            return (ABlob)this.entry.getKey();
        }
        int n = this.children.length;
        if (n == 0) {
            return Blob.EMPTY;
        }
        return this.children[0].getValue().getPrefix();
    }

    @Override
    protected void accumulateEntrySet(HashSet<Map.Entry<K, V>> h) {
        for (int i = 0; i < this.children.length; ++i) {
            this.children[i].getValue().accumulateEntrySet(h);
        }
        if (this.entry != null) {
            h.add(this.entry);
        }
    }

    @Override
    protected void accumulateKeySet(HashSet<K> h) {
        for (int i = 0; i < this.children.length; ++i) {
            this.children[i].getValue().accumulateKeySet(h);
        }
        if (this.entry != null) {
            h.add((ABlob)this.entry.getKey());
        }
    }

    @Override
    protected void accumulateValues(ArrayList<V> al) {
        if (this.entry != null) {
            al.add(this.entry.getValue());
        }
        for (int i = 0; i < this.children.length; ++i) {
            this.children[i].getValue().accumulateValues(al);
        }
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        if (this.entry != null) {
            action.accept(this.entry.getKey(), this.entry.getValue());
        }
        for (int i = 0; i < this.children.length; ++i) {
            this.children[i].getValue().forEach(action);
        }
    }

    @Override
    public BlobMap<K, V> assocEntry(MapEntry<K, V> e) {
        if (this.count == 0L) {
            return BlobMap.create(e);
        }
        if (this.count == 1L) {
            assert (this.mask == 0);
            if (this.entry.keyEquals(e)) {
                if (this.entry == e) {
                    return this;
                }
                return BlobMap.createAtDepth(e, this.depth);
            }
        }
        ABlob k = (ABlob)e.getKey();
        long pDepth = this.prefixDepth();
        long newKeyLength = k.hexLength();
        ABlob prefix = this.getPrefix();
        long mkl = newKeyLength >= pDepth ? this.depth + k.hexMatchLength(prefix, this.depth, this.prefixLength) : this.depth + k.hexMatchLength(prefix, this.depth, newKeyLength - this.depth);
        if (mkl < pDepth) {
            int d2;
            if (mkl == newKeyLength) {
                long newDepth = mkl + 1L;
                BlobMap<K, V> split = new BlobMap<K, V>(newDepth, pDepth - newDepth, this.entry, this.children, this.mask, this.count);
                int splitDigit = prefix.getHexDigit(mkl);
                short splitMask = (short)(1 << splitDigit);
                BlobMap<K, V> result = new BlobMap<K, V>(this.depth, mkl - this.depth, e, new Ref[]{split.getRef()}, splitMask, this.count + 1L);
                return result;
            }
            long newDepth = mkl + 1L;
            BlobMap<K, V> branch1 = new BlobMap<K, V>(newDepth, pDepth - newDepth, this.entry, this.children, this.mask, this.count);
            BlobMap<K, V> branch2 = new BlobMap<K, V>(newDepth, newKeyLength - newDepth, e, EMPTY_CHILDREN, 0, 1L);
            int d1 = prefix.getHexDigit(mkl);
            if (d1 > (d2 = k.getHexDigit(mkl))) {
                BlobMap<K, V> temp = branch1;
                branch1 = branch2;
                branch2 = temp;
            }
            Ref[] newChildren = new Ref[]{branch1.getRef(), branch2.getRef()};
            short newMask = (short)(1 << d1 | 1 << d2);
            BlobMap<K, V> fork = new BlobMap<K, V>(this.depth, mkl - this.depth, null, newChildren, newMask, this.count + 1L);
            return fork;
        }
        assert (newKeyLength >= pDepth);
        if (newKeyLength == pDepth) {
            if (this.entry == null) {
                return new BlobMap<K, V>(this.depth, this.prefixLength, e, this.children, this.mask, this.count + 1L);
            }
            if (this.entry == e) {
                return this;
            }
            return new BlobMap<K, V>(this.depth, this.prefixLength, e, this.children, this.mask, this.count);
        }
        int childDigit = k.getHexDigit(pDepth);
        BlobMap<K, V> oldChild = this.getChild(childDigit);
        BlobMap<K, V> newChild = oldChild == null ? BlobMap.createAtDepth(e, pDepth + 1L) : oldChild.assocEntry((MapEntry)e);
        return this.withChild(childDigit, oldChild, newChild);
    }

    private BlobMap<K, V> withChild(int childDigit, BlobMap<K, V> oldChild, BlobMap<K, V> newChild) {
        if (oldChild == newChild) {
            return this;
        }
        int n = this.children.length;
        Ref<BlobMap<K, V>>[] newChildren = this.children;
        if (oldChild == null) {
            newChildren = new Ref[n + 1];
            int newPos = Bits.positionForDigit(childDigit, this.mask);
            short newMask = (short)(this.mask | 1 << childDigit);
            System.arraycopy(this.children, 0, newChildren, 0, newPos);
            newChildren[newPos] = newChild.getRef();
            System.arraycopy(this.children, newPos, newChildren, newPos + 1, n - newPos);
            return new BlobMap<K, V>(this.depth, this.prefixLength, this.entry, newChildren, newMask, this.count + newChild.count());
        }
        if (newChild == null) {
            int delPos = Bits.positionForDigit(childDigit, this.mask);
            if (this.entry == null) {
                if (n == 2) {
                    BlobMap<K, V> rm = this.children[1 - delPos].getValue();
                    long newPLength = this.prefixLength + rm.prefixLength + 1L;
                    return new BlobMap<K, V>(this.depth, newPLength, rm.entry, rm.children, rm.mask, rm.count());
                }
                if (n == 1) {
                    return null;
                }
            }
            if (n == 0) {
                System.out.print("BlobMap Bad!");
            }
            newChildren = new Ref[n - 1];
            short newMask = (short)(this.mask & ~(1 << childDigit));
            System.arraycopy(this.children, 0, newChildren, 0, delPos);
            System.arraycopy(this.children, delPos + 1, newChildren, delPos, n - delPos - 1);
            return new BlobMap<K, V>(this.depth, this.prefixLength, this.entry, newChildren, newMask, this.count - oldChild.count());
        }
        int childPos = Bits.positionForDigit(childDigit, this.mask);
        newChildren = (Ref[])this.children.clone();
        newChildren[childPos] = newChild.getRef();
        long newCount = this.count + newChild.count() - oldChild.count();
        return new BlobMap<K, V>(this.depth, this.prefixLength, this.entry, newChildren, this.mask, newCount);
    }

    @Override
    public <R> R reduceValues(BiFunction<? super R, ? super V, ? extends R> func, R initial) {
        if (this.entry != null) {
            initial = func.apply(initial, this.entry.getValue());
        }
        int n = this.children.length;
        for (int i = 0; i < n; ++i) {
            initial = this.children[i].getValue().reduceValues(func, initial);
        }
        return initial;
    }

    @Override
    public <R> R reduceEntries(BiFunction<? super R, MapEntry<K, V>, ? extends R> func, R initial) {
        if (this.entry != null) {
            initial = func.apply(initial, this.entry);
        }
        int n = this.children.length;
        for (int i = 0; i < n; ++i) {
            initial = this.children[i].getValue().reduceEntries(func, initial);
        }
        return initial;
    }

    @Override
    public BlobMap<K, V> filterValues(Predicate<V> pred) {
        ADataStructure r = this;
        for (int i = 0; i < 16 && r != null; ++i) {
            BlobMap<K, V> oldChild = ((BlobMap)r).getChild(i);
            if (oldChild == null) continue;
            AMap newChild = oldChild.filterValues((Predicate)pred);
            r = ((BlobMap)r).withChild(i, oldChild, (BlobMap<K, V>)newChild);
        }
        if (r != null && ((BlobMap)r).entry != null && !pred.test(((BlobMap)r).entry.getValue())) {
            r = ((BlobMap)r).dissoc((ABlob)((BlobMap)r).entry.getKey());
        }
        if (r == null && this.depth == 0L) {
            r = this.empty();
        }
        return r;
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = -124;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = Format.writeVLCLong(bs, pos, this.count);
        if (this.count == 0L) {
            return pos;
        }
        pos = Format.writeVLCLong(bs, pos, this.depth);
        pos = Format.writeVLCLong(bs, pos, this.prefixLength);
        pos = MapEntry.encodeCompressed(this.entry, bs, pos);
        if (this.count == 1L) {
            return pos;
        }
        pos = Utils.writeShort(bs, pos, this.mask);
        int n = this.children.length;
        for (int i = 0; i < n; ++i) {
            pos = this.encodeChild(bs, pos, i);
        }
        return pos;
    }

    private int encodeChild(byte[] bs, int pos, int i) {
        Ref<BlobMap<K, V>> cref = this.children[i];
        return cref.encode(bs, pos);
    }

    @Override
    public int estimatedEncodingSize() {
        return 100 + (this.children.length * 2 + 1) * 140;
    }

    public static <K extends ABlob, V extends ACell> BlobMap<K, V> read(ByteBuffer bb) throws BadFormatException {
        long count = Format.readVLCLong(bb);
        if (count < 0L) {
            throw new BadFormatException("Negative count!");
        }
        if (count == 0L) {
            return EMPTY;
        }
        long depth = Format.readVLCLong(bb);
        if (depth < 0L) {
            throw new BadFormatException("Negative depth!");
        }
        long prefixLength = Format.readVLCLong(bb);
        if (prefixLength < 0L) {
            throw new BadFormatException("Negative prefix length!");
        }
        MapEntry me = MapEntry.readCompressed(bb);
        if (count == 1L) {
            return new BlobMap(depth, prefixLength, me, EMPTY_CHILDREN, 0, 1L);
        }
        short mask = bb.getShort();
        int n = Utils.bitCount(mask);
        Ref[] children = new Ref[n];
        long childDepth = depth + prefixLength + 1L;
        for (int i = 0; i < n; ++i) {
            children[i] = BlobMap.readChild(bb, childDepth);
        }
        return new BlobMap(depth, prefixLength, me, children, mask, count);
    }

    private static Ref<BlobMap> readChild(ByteBuffer bb, long childDepth) throws BadFormatException {
        Ref<BlobMap> ref = Format.readRef(bb);
        return ref;
    }

    @Override
    protected MapEntry<K, V> getEntryByHash(Hash hash) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void validate() throws InvalidDataException {
        super.validate();
        long ecount = this.entry == null ? 0L : 1L;
        int n = this.children.length;
        long pDepth = this.prefixDepth();
        for (int i = 0; i < n; ++i) {
            BlobMap<K, V> o = this.children[i].getValue();
            if (!(o instanceof BlobMap)) {
                throw new InvalidDataException("Illegal BlobMap child type: " + Utils.getClass(o), this);
            }
            BlobMap<K, V> c = o;
            long ccount = c.count();
            if (ccount == 0L) {
                throw new InvalidDataException("Child " + i + " should not be empty! At depth " + this.depth, this);
            }
            if (c.depth != pDepth + 1L) {
                throw new InvalidDataException("Child must have depth: " + (pDepth + 1L) + " but was: " + c.depth, this);
            }
            if (c.prefixDepth() <= this.prefixDepth()) {
                throw new InvalidDataException("Child must have greater total prefix depth than " + this.prefixDepth() + " but was: " + c.prefixDepth(), this);
            }
            c.validate();
            ecount += ccount;
        }
        if (this.count != ecount) {
            throw new InvalidDataException("Bad entry count: " + ecount + " expected: " + this.count, this);
        }
    }

    private long prefixDepth() {
        return this.depth + this.prefixLength;
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.prefixLength < 0L) {
            throw new InvalidDataException("Negative prefix length!" + this.prefixLength, this);
        }
        if (this.count == 0L) {
            if (this != EMPTY) {
                throw new InvalidDataException("Non-singleton empty BlobMap", this);
            }
            return;
        }
        if (this.count == 1L) {
            if (this.entry == null) {
                throw new InvalidDataException("Single entry BlobMap with null entry?", this);
            }
            if (this.mask != 0) {
                throw new InvalidDataException("Single entry BlobMap with child mask?", this);
            }
            return;
        }
        int cn = Utils.bitCount(this.mask);
        if (cn != this.children.length) {
            throw new InvalidDataException("Illegal mask: " + Utils.toHexString(this.mask) + " for given number of children: " + this.children.length, this);
        }
        if (this.entry != null) {
            this.entry.validateCell();
            if (cn == 0) {
                throw new InvalidDataException("BlobMap with entry and count=" + this.count + " must have children", this);
            }
        } else if (cn <= 1) {
            throw new InvalidDataException("BlobMap with no entry and count=" + this.count + " must have two or more children", this);
        }
    }

    public BlobMap<K, V> empty() {
        return EMPTY;
    }

    @Override
    public MapEntry<K, V> entryAt(long ix) {
        if (this.entry != null) {
            if (ix == 0L) {
                return this.entry;
            }
            --ix;
        }
        int n = this.children.length;
        for (int i = 0; i < n; ++i) {
            ABlobMap c = this.children[i].getValue();
            long cc = c.count();
            if (ix < cc) {
                return c.entryAt(ix);
            }
            ix -= cc;
        }
        throw new IndexOutOfBoundsException(Errors.badIndex(ix));
    }

    public BlobMap<K, V> removeLeadingEntries(long n) {
        ABlobMap bm = this;
        for (long i = 0L; i < n; ++i) {
            MapEntry<K, V> me = bm.entryAt(0L);
            bm = bm.dissoc((ABlob)me.getKey());
        }
        return bm;
    }

    @Override
    public boolean equals(AMap<K, V> a) {
        if (this == a) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (this.getType() != a.getType()) {
            return false;
        }
        return this.equals((BlobMap)a);
    }

    @Override
    public boolean equals(BlobMap<K, V> a) {
        Hash ha;
        if (a == null) {
            return false;
        }
        long n = this.count();
        if (n != a.count()) {
            return false;
        }
        if (this.mask != a.mask) {
            return false;
        }
        if (!Utils.equals(this.entry, a.entry)) {
            return false;
        }
        Hash h = this.cachedHash();
        if (h != null && (ha = a.cachedHash()) != null) {
            return h.equals(ha);
        }
        return this.getHash().equals(a.getHash());
    }

    @Override
    public byte getTag() {
        return -124;
    }

    @Override
    public ACell toCanonical() {
        return this;
    }

    static {
        EMPTY.getRef().setFlags(85);
    }
}

