/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.AArrayBlob;
import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.Blob;
import convex.core.data.Hash;
import convex.core.data.Ref;
import convex.core.data.RefDirect;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.exceptions.InvalidDataException;
import convex.core.util.Errors;
import convex.core.util.Utils;
import java.nio.ByteBuffer;

public class AccountKey
extends AArrayBlob {
    public static final int LENGTH = 32;
    public static final AType TYPE = Types.BLOB;
    public static final int LENGTH_BITS = 256;
    public static final AccountKey ZERO = AccountKey.dummy("0");

    private AccountKey(byte[] data, int offset, int length) {
        super(data, offset, length);
        if (length != 32) {
            throw new IllegalArgumentException("AccountKey length must be 32 bytes");
        }
    }

    @Override
    public AType getType() {
        return TYPE;
    }

    @Override
    protected <R extends ACell> Ref<R> createRef() {
        RefDirect<AccountKey> newRef;
        this.cachedRef = newRef = RefDirect.create(this, this.cachedHash(), 85);
        return newRef;
    }

    public static AccountKey wrap(byte[] data) {
        return new AccountKey(data, 0, data.length);
    }

    public static AccountKey wrap(byte[] data, int offset) {
        return new AccountKey(data, offset, 32);
    }

    public static AccountKey create(ABlob b) {
        if (b.count() != 32L) {
            return null;
        }
        if (b instanceof AccountKey) {
            return (AccountKey)b;
        }
        if (b instanceof AArrayBlob) {
            AArrayBlob ab = (AArrayBlob)b;
            return new AccountKey(ab.getInternalArray(), ab.getInternalOffset(), 32);
        }
        return AccountKey.wrap(b.getBytes());
    }

    public static AccountKey dummy(String nonce) {
        int n = nonce.length();
        if (n == 0) {
            throw new Error("Empty nonce");
        }
        if (n >= 16) {
            throw new Error("Nonce too long for dummy address");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 64; i += n) {
            sb.append(nonce);
        }
        return AccountKey.fromHex(sb.substring(0, 64));
    }

    @Override
    public boolean equals(ABlob o) {
        if (o == null) {
            return false;
        }
        if (o instanceof AccountKey) {
            return this.equals((AccountKey)o);
        }
        if (o.getType() != TYPE) {
            return false;
        }
        if (o.count() != 32L) {
            return false;
        }
        return o.equalsBytes(this.store, this.offset);
    }

    public boolean equals(AccountKey o) {
        if (o == this) {
            return true;
        }
        return Utils.arrayEquals(o.store, o.offset, this.store, this.offset, 32);
    }

    public static AccountKey fromHex(String hexString) {
        AccountKey result = AccountKey.fromHexOrNull(hexString);
        if (result == null) {
            throw new Error("Invalid Address hex String [" + hexString + "]");
        }
        return result;
    }

    public static AccountKey fromHexOrNull(String hexString) {
        byte[] bs = Utils.hexToBytes(hexString, 64);
        if (bs == null) {
            return null;
        }
        if (bs.length != 32) {
            return null;
        }
        return AccountKey.wrap(bs);
    }

    public static AccountKey fromHexOrNull(AString a) {
        if (a.length() != 64) {
            return null;
        }
        return AccountKey.fromHexOrNull(a.toString());
    }

    public static AccountKey fromChecksumHex(String hexString) {
        byte[] bs = Utils.hexToBytes(hexString, 64);
        AccountKey a = AccountKey.wrap(bs);
        Hash h = a.getContentHash();
        for (int i = 0; i < 64; ++i) {
            boolean check;
            int dh = h.getHexDigit(i);
            char c = hexString.charAt(i);
            if (Character.isDigit(c) || (check = c >= 'a' ^ dh >= 8)) continue;
            throw new IllegalArgumentException("Bad checksum at position " + i + " in address " + hexString);
        }
        return a;
    }

    public String toChecksumHex() {
        StringBuilder sb = new StringBuilder(64);
        Hash h = this.getContentHash();
        for (int i = 0; i < 64; ++i) {
            int dh = h.getHexDigit(i);
            int da = this.getHexDigit(i);
            if (da < 10) {
                sb.append((char)(48 + da));
                continue;
            }
            boolean up = dh >= 8;
            sb.append((char)((up ? 65 : 97) + da - 10));
        }
        return sb.toString();
    }

    public static AccountKey readRaw(ByteBuffer data) {
        byte[] buff = new byte[32];
        data.get(buff);
        return AccountKey.wrap(buff);
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = 49;
        bs[pos++] = 32;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public final boolean isCVMValue() {
        return true;
    }

    @Override
    public int estimatedEncodingSize() {
        return 35;
    }

    @Override
    public long getEncodingLength() {
        return 34L;
    }

    @Override
    public Blob getChunk(long i) {
        if (i != 0L) {
            throw new IndexOutOfBoundsException(Errors.badIndex(i));
        }
        return this.toBlob();
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.length != 32) {
            throw new InvalidDataException("Address length must be 32  bytes = 256 bits", this);
        }
    }

    @Override
    public boolean isEmbedded() {
        return true;
    }

    @Override
    protected long calcMemorySize() {
        return 0L;
    }

    @Override
    public boolean isRegularBlob() {
        return true;
    }

    @Override
    public byte getTag() {
        return 49;
    }

    @Override
    public boolean isCanonical() {
        return false;
    }

    @Override
    public Blob toCanonical() {
        return this.toBlob();
    }
}

