/*
 * Decompiled with CFR 0.152.
 */
package convex.core.init;

import convex.core.Constants;
import convex.core.State;
import convex.core.data.ACell;
import convex.core.data.AList;
import convex.core.data.AVector;
import convex.core.data.AccountKey;
import convex.core.data.AccountStatus;
import convex.core.data.Address;
import convex.core.data.BlobMap;
import convex.core.data.BlobMaps;
import convex.core.data.PeerStatus;
import convex.core.data.Vectors;
import convex.core.lang.Context;
import convex.core.lang.Core;
import convex.core.lang.RT;
import convex.core.lang.Reader;
import convex.core.lang.Symbols;
import convex.core.util.Utils;
import java.io.IOException;
import java.util.List;

public class Init {
    public static final Address NULL_ADDRESS = Address.create(0L);
    public static final Address INIT_ADDRESS = Address.create(1L);
    public static final Address RESERVED_ADDRESS = Address.create(2L);
    public static final Address MAINBANK_ADDRESS = Address.create(3L);
    public static final Address ROOTFUND_ADDRESS = Address.create(4L);
    public static final Address MAINPOOL_ADDRESS = Address.create(5L);
    public static final Address LIVEPOOL_ADDRESS = Address.create(6L);
    public static final Address MEMORY_EXCHANGE_ADDRESS = Address.create(7L);
    public static final Address CORE_ADDRESS = Address.create(8L);
    public static final Address REGISTRY_ADDRESS = Address.create(9L);
    public static final Address TRUST_ADDRESS = Address.create(10L);
    public static final Address GENESIS_ADDRESS = Address.create(11L);

    public static State createBaseState(List<AccountKey> genesisKeys) {
        BlobMap<AccountKey, PeerStatus> peers = (BlobMap<AccountKey, PeerStatus>)BlobMaps.empty();
        AVector<AccountStatus> accts = Vectors.empty();
        long supply = 1000000000000000000L;
        accts = Init.addGovernanceAccount(accts, NULL_ADDRESS, 0L);
        accts = Init.addGovernanceAccount(accts, INIT_ADDRESS, 0L);
        long reserved = 100000000000000000L;
        accts = Init.addGovernanceAccount(accts, RESERVED_ADDRESS, reserved);
        supply -= reserved;
        long governance = 240000000000000000L;
        accts = Init.addGovernanceAccount(accts, MAINBANK_ADDRESS, governance);
        supply -= governance;
        long rootFund = 8000000000000000L;
        accts = Init.addGovernanceAccount(accts, ROOTFUND_ADDRESS, rootFund);
        supply -= rootFund;
        long mainPool = 1000000000000000L;
        accts = Init.addGovernanceAccount(accts, MAINPOOL_ADDRESS, mainPool);
        supply -= mainPool;
        long livePool = 5000000000000L;
        accts = Init.addGovernanceAccount(accts, LIVEPOOL_ADDRESS, 5000000000000L);
        supply -= livePool;
        long memoryCoins = 1000000000000L;
        accts = Init.addMemoryExchange(accts, MEMORY_EXCHANGE_ADDRESS, memoryCoins, 1000000000L);
        supply -= memoryCoins;
        int keyCount = genesisKeys.size();
        assert (keyCount > 0);
        accts = Init.addCoreLibrary(accts, CORE_ADDRESS);
        AVector<ACell> globals = Constants.INITIAL_GLOBALS;
        State s = State.create(accts, peers, globals, (BlobMap)BlobMaps.empty());
        s = Init.createStaticLibraries(s, TRUST_ADDRESS, REGISTRY_ADDRESS);
        accts = s.getAccounts();
        assert (accts.count() == GENESIS_ADDRESS.longValue());
        long userFunds = (long)((double)supply * 0.8);
        supply -= userFunds;
        long genFunds = userFunds / 2L;
        accts = Init.addAccount(accts, GENESIS_ADDRESS, genesisKeys.get(0), genFunds);
        userFunds -= genFunds;
        for (int i = 0; i < keyCount; ++i) {
            Address address = Address.create(accts.count());
            assert (address.longValue() == accts.count());
            AccountKey key = genesisKeys.get(i);
            long userBalance = userFunds / (long)(keyCount - i);
            accts = Init.addAccount(accts, address, key, userBalance);
            userFunds -= userBalance;
        }
        assert (userFunds == 0L);
        long peerFunds = supply;
        supply -= peerFunds;
        for (int i = 0; i < keyCount; ++i) {
            AccountKey peerKey = genesisKeys.get(i);
            Address peerController = Init.getGenesisPeerAddress(i);
            long peerStake = peerFunds / (long)(keyCount - i);
            peers = Init.addPeer(peers, peerKey, peerController, peerStake);
            peerFunds -= peerStake;
        }
        assert (peerFunds == 0L);
        s = s.withAccounts(accts);
        long total = (s = s.withPeers(peers)).computeTotalFunds();
        if (total != 1000000000000000000L) {
            throw new Error("Bad total amount: " + total);
        }
        return s;
    }

    public static State createStaticLibraries(State s, Address trustAddress, Address registryAddress) {
        s = Init.doActorDeploy(s, "convex/registry.cvx");
        s = Init.doActorDeploy(s, "convex/trust.cvx");
        Context ctx = Context.createFake(s, INIT_ADDRESS);
        ctx = ctx.eval((ACell)Reader.read("(call *registry* (cns-update 'convex.core " + CORE_ADDRESS + "))"));
        s = ctx.getState();
        s = Init.register(s, CORE_ADDRESS, "Convex Core Library", "Core utilities accessible by default in any account.");
        s = Init.register(s, MEMORY_EXCHANGE_ADDRESS, "Memory Exchange Pool", "Automated exchange following the Convex memory allowance model.");
        return s;
    }

    public static State createState(List<AccountKey> genesisKeys) {
        try {
            State s = Init.createBaseState(genesisKeys);
            s = Init.doActorDeploy(s, "convex/fungible.cvx");
            s = Init.doActorDeploy(s, "convex/trusted-oracle/actor.cvx");
            s = Init.doActorDeploy(s, "convex/trusted-oracle.cvx");
            s = Init.doActorDeploy(s, "convex/asset.cvx");
            s = Init.doActorDeploy(s, "torus/exchange.cvx");
            s = Init.doActorDeploy(s, "asset/nft-tokens.cvx");
            s = Init.doActorDeploy(s, "asset/simple-nft.cvx");
            s = Init.doActorDeploy(s, "asset/box/actor.cvx");
            s = Init.doActorDeploy(s, "asset/box.cvx");
            s = Init.doActorDeploy(s, "convex/play.cvx");
            AVector table = (AVector)Reader.readResourceAsData("torus/currencies.cvx");
            for (AVector row : table) {
                s = Init.doCurrencyDeploy(s, row);
            }
            long finalTotal = s.computeTotalFunds();
            if (finalTotal != 1000000000000000000L) {
                throw new Error("Bad total funds in init state amount: " + finalTotal);
            }
            return s;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw (RuntimeException)Utils.sneakyThrow(e);
        }
    }

    public static Address calcPeerAddress(int userCount, int index) {
        return Address.create(GENESIS_ADDRESS.longValue() + (long)userCount + (long)index);
    }

    public static Address calcUserAddress(int index) {
        return Address.create(GENESIS_ADDRESS.longValue() + (long)index);
    }

    private static State doActorDeploy(State s, String resource) {
        Context<Object> ctx = Context.createFake(s, INIT_ADDRESS);
        try {
            AList<ACell> forms = Reader.readAll(Utils.readResourceAsString(resource));
            ctx = ctx.deployActor(forms.next().cons(Symbols.DO));
            if (ctx.isExceptional()) {
                throw new Error("Error deploying actor:" + ctx.getValue());
            }
            if ((ctx = ctx.eval((ACell)Reader.read("(call *registry* (cns-update " + (ACell)forms.get(0) + " " + (ACell)ctx.getResult() + "))"))).isExceptional()) {
                throw new Error("Error while registering actor:" + ctx.getValue());
            }
            return ctx.getState();
        }
        catch (IOException e) {
            throw (RuntimeException)Utils.sneakyThrow(e);
        }
    }

    private static State doCurrencyDeploy(State s, AVector<ACell> row) {
        String symbol = ((ACell)row.get(0)).toString();
        double usdValue = (Double)RT.jvm((ACell)row.get(6));
        long decimals = (Long)RT.jvm((ACell)row.get(5));
        double liquidity = (double)((Long)RT.jvm((ACell)row.get(4))).longValue() * Math.pow(10.0, decimals);
        double price = usdValue * 1000.0;
        double cvx = price * liquidity / Math.pow(10.0, decimals);
        long supply = 1000000000000L;
        Context ctx = Context.createFake(s, MAINBANK_ADDRESS);
        ctx = ctx.eval((ACell)Reader.read("(do (import convex.fungible :as fun) (deploy (fun/build-token {:supply " + supply + "})))"));
        Address addr = (Address)ctx.getResult();
        if ((ctx = ctx.eval((ACell)Reader.read("(do (import torus.exchange :as torus) (torus/add-liquidity " + addr + " " + liquidity + " " + cvx + "))"))).isExceptional()) {
            throw new Error("Error adding market liquidity: " + ctx.getValue());
        }
        if ((ctx = ctx.eval((ACell)Reader.read("(call *registry* (cns-update 'currency." + symbol + " " + addr + "))"))).isExceptional()) {
            throw new Error("Error registering currency in CNS: " + ctx.getValue());
        }
        return ctx.getState();
    }

    private static State register(State state, Address origin, String name, String description) {
        Context ctx = Context.createFake(state, origin);
        ctx = ctx.eval((ACell)Reader.read("(call *registry* (register {:description \"" + description + "\" :name \"" + name + "\"}))"));
        return ctx.getState();
    }

    public static Address getGenesisAddress() {
        return GENESIS_ADDRESS;
    }

    public static Address getGenesisPeerAddress(int index) {
        return GENESIS_ADDRESS.offset(index + 1);
    }

    private static BlobMap<AccountKey, PeerStatus> addPeer(BlobMap<AccountKey, PeerStatus> peers, AccountKey peerKey, Address owner, long initialStake) {
        PeerStatus ps = PeerStatus.create(owner, initialStake, null);
        return peers.assoc(peerKey, ps);
    }

    private static AVector<AccountStatus> addGovernanceAccount(AVector<AccountStatus> accts, Address a, long balance) {
        if (accts.count() != a.longValue()) {
            throw new Error("Incorrect initialisation address: " + a);
        }
        AccountStatus as = AccountStatus.createGovernance(balance);
        accts = accts.conj(as);
        return accts;
    }

    private static AVector<AccountStatus> addMemoryExchange(AVector<AccountStatus> accts, Address a, long balance, long allowance) {
        if (accts.count() != a.longValue()) {
            throw new Error("Incorrect memory exchange address: " + a);
        }
        AccountStatus as = AccountStatus.createGovernance(balance).withMemory(allowance);
        accts = accts.conj(as);
        return accts;
    }

    private static AVector<AccountStatus> addCoreLibrary(AVector<AccountStatus> accts, Address a) {
        if (accts.count() != a.longValue()) {
            throw new Error("Incorrect core library address: " + a);
        }
        AccountStatus as = AccountStatus.createActor();
        as = as.withEnvironment(Core.ENVIRONMENT);
        as = as.withMetadata(Core.METADATA);
        accts = accts.conj(as);
        return accts;
    }

    private static AVector<AccountStatus> addAccount(AVector<AccountStatus> accts, Address a, AccountKey key, long balance) {
        if (accts.count() != a.longValue()) {
            throw new Error("Incorrect account address: " + a);
        }
        AccountStatus as = AccountStatus.create(0L, balance, key);
        as = as.withMemory(10000000L);
        accts = accts.conj(as);
        return accts;
    }
}

