/*
 * Decompiled with CFR 0.152.
 */
package convex.cli.peer;

import convex.cli.CLIError;
import convex.cli.peer.APeerCommand;
import convex.cli.peer.Peer;
import convex.core.crypto.AKeyPair;
import convex.core.cvm.Keywords;
import convex.core.cvm.State;
import convex.core.data.AccountKey;
import convex.core.data.Keyword;
import convex.core.init.Init;
import convex.etch.EtchStore;
import convex.peer.API;
import convex.peer.Server;
import java.util.HashMap;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="genesis", mixinStandardHelpOptions=true, description={"Instantiate a Convex network."})
public class PeerGenesis
extends APeerCommand {
    @CommandLine.ParentCommand
    private Peer peerParent;
    @CommandLine.Option(names={"--governance-key"}, defaultValue="${env:CONVEX_GOVERNANCE_KEY}", scope=CommandLine.ScopeType.INHERIT, description={"Network Governance Key. Must be a valid Ed25519 public key. Genesis key will be used if not specified (unless security is strict)."})
    protected String governanceKey;

    @Override
    public void execute() throws InterruptedException {
        this.storeMixin.ensureKeyStore();
        AKeyPair genesisKey = this.ensureControllerKey();
        if (genesisKey == null) {
            this.informWarning("You must specify at least a genesis --key");
            this.showUsage();
            return;
        }
        try (EtchStore etch = this.etchMixin.getEtchStore();){
            AccountKey govKey;
            AKeyPair peerKey = this.specifiedPeerKey();
            if (peerKey == null) {
                this.paranoia("--peer-key must be specified in strict mode");
                peerKey = genesisKey;
                this.inform("Using genesis key for first peer: " + String.valueOf(genesisKey.getAccountKey()));
            }
            if ((govKey = AccountKey.parse((String)this.governanceKey)) == null) {
                this.paranoia("--governance-key must be specified in strict security mode");
                if (this.governanceKey == null) {
                    this.inform("Using genesis key for governance: " + String.valueOf(genesisKey.getAccountKey()));
                    govKey = genesisKey.getAccountKey();
                } else {
                    throw new CLIError(65, "Unable to parse --governance-key argument. Should be a 32-byte hex key.");
                }
            }
            EtchStore store = this.getEtchStore();
            State genesisState = Init.createState((AccountKey)govKey, (AccountKey)genesisKey.getAccountKey(), List.of(peerKey.getAccountKey()));
            this.inform("Created genesis state with hash: " + String.valueOf(genesisState.getHash()));
            this.inform("Testing genesis state peer initialisation");
            HashMap<Keyword, Object> config = new HashMap<Keyword, Object>();
            config.put(Keywords.STORE, store);
            config.put(Keywords.STATE, genesisState);
            config.put(Keywords.KEYPAIR, peerKey);
            Server s = API.launchPeer(config);
            s.close();
            this.informSuccess("Convex genesis succeeded!");
        }
    }
}

