/*
 * Decompiled with CFR 0.152.
 */
package convex.cli.peer;

import convex.cli.CLIError;
import convex.cli.peer.APeerCommand;
import convex.core.cvm.Peer;
import convex.core.data.ACell;
import convex.core.data.AMap;
import convex.core.data.AccountKey;
import convex.core.store.AStore;
import convex.core.util.FileUtils;
import convex.core.util.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="backup", mixinStandardHelpOptions=true, description={"Backup stored data for a peer"})
public class PeerBackup
extends APeerCommand {
    @CommandLine.Option(names={"--output-file", "-o"}, description={"Output file for peer CAD3 data. Defaults to timestamped CAD3 file."})
    private String outFile;

    @Override
    protected void execute() throws InterruptedException {
        AMap peerData;
        AccountKey k = this.peerKeyMixin.getAcountKey();
        if (k == null) {
            List<AccountKey> peerList = this.etchMixin.getPeerList();
            int n = peerList.size();
            if (n == 0) {
                throw new CLIError("No peers available in store: " + String.valueOf(this.etchMixin.getEtchStore()));
            }
            String s = this.peerKeyMixin.getPublicKey();
            if (s != null) {
                peerList.removeIf(pk -> !pk.toHexString().startsWith(s));
                n = peerList.size();
            }
            if (n == 0) {
                throw new CLIError("No peer in store with prefix: " + s);
            }
            if (n == 1) {
                k = peerList.get(0);
            } else {
                if (n == 0) {
                    throw new CLIError("No peers available in store: " + String.valueOf(this.etchMixin.getEtchStore()));
                }
                this.informWarning("Need to select peer to backup, available peers are:");
                for (AccountKey pk2 : peerList) {
                    this.inform(pk2.toHexString());
                }
                throw new CLIError("Please specify which peer to backup with --peer-key");
            }
        }
        try {
            peerData = Peer.getPeerData((AStore)this.etchMixin.getEtchStore(), (ACell)k);
            if (peerData == null) {
                throw new CLIError("No peer data found for key: " + String.valueOf(k));
            }
        }
        catch (Exception e) {
            throw new CLIError("Unable to access peer data", e);
        }
        if (this.outFile == null) {
            this.outFile = "peer-backup-" + k.toHexString(8) + "-" + Utils.timeString() + ".cad3";
        }
        File f = FileUtils.getFile((String)this.outFile);
        try {
            FileUtils.writeCAD3((Path)f.toPath(), (ACell)peerData);
            this.inform("Peer data written to: " + String.valueOf(f));
        }
        catch (IOException e) {
            throw new CLIError("Unable to write peer data", e);
        }
    }
}

