/*
 * Decompiled with CFR 0.152.
 */
package convex.cli.local;

import convex.cli.CLIError;
import convex.cli.Helpers;
import convex.cli.local.ALocalCommand;
import convex.cli.local.Local;
import convex.core.crypto.AKeyPair;
import convex.core.cvm.State;
import convex.core.init.Init;
import convex.peer.API;
import convex.peer.PeerException;
import convex.peer.Server;
import convex.restapi.RESTServer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="start", mixinStandardHelpOptions=true, description={"Starts a temporary local convex test network. Useful for development and testing purposes."})
public class LocalStart
extends ALocalCommand {
    private static final Logger log = LoggerFactory.getLogger(LocalStart.class);
    @CommandLine.ParentCommand
    private Local localParent;
    @CommandLine.Option(names={"--count"}, defaultValue="3", description={"Number of local peers to start. Default: ${DEFAULT-VALUE}"})
    private int count;
    @CommandLine.Option(names={"--public-key"}, defaultValue="", description={"One or more hex string of the public key in the Keystore to use to run a peer.%nYou only need to enter in the first distinct hex values of the public key.%nFor example: 0xf0234 or f0234"})
    private String[] keystorePublicKey;
    @CommandLine.Option(names={"--ports"}, description={"List of ports to assign to peers. If not specified, will attempt to find available ports.e.g. --ports=8081,8082,8083 "})
    private String[] ports;
    @CommandLine.Option(names={"--api-port"}, defaultValue="8080", description={"REST API port, enables REST API to the first peer in the local cluster. Default: ${DEFAULT-VALUE}"})
    private int apiPort;

    private List<AKeyPair> getPeerKeyPairs(int count) {
        int left;
        ArrayList<AKeyPair> keyPairList = new ArrayList<AKeyPair>();
        if (this.keystorePublicKey.length > 0) {
            List<String> values = Helpers.splitArrayParameter(this.keystorePublicKey);
            for (int index = 0; index < values.size(); ++index) {
                String keyPrefix = values.get(index);
                if (keyPrefix.isBlank()) continue;
                AKeyPair keyPair = this.storeMixin.loadKeyFromStore(keyPrefix, () -> this.keyMixin.getKeyPassword());
                if (keyPair == null) {
                    log.warn("Unable to find public key in store: " + keyPrefix);
                    continue;
                }
                keyPairList.add(keyPair);
            }
        }
        if ((left = count - keyPairList.size()) > 0) {
            this.informWarning("Insufficient key pairs specified. Additional " + left + " keypair(s) will be generated");
            for (int i = 0; i < left; ++i) {
                AKeyPair kp = AKeyPair.generate();
                keyPairList.add(kp);
                log.info("Generated key: " + kp.getAccountKey().toChecksumHex() + " Priv: " + String.valueOf(kp.getSeed()));
            }
        }
        if (new HashSet(keyPairList).size() < keyPairList.size()) {
            throw new CLIError("Duplicate peer keys provided!");
        }
        return new ArrayList<AKeyPair>(keyPairList);
    }

    private int[] getPeerPorts() {
        int[] peerPorts = null;
        if (this.ports != null) {
            peerPorts = Helpers.getPortList(this.ports, this.count);
            if (peerPorts == null) {
                throw new CLIError(65, "Failed to parse port list");
            }
            if (peerPorts.length < this.count) {
                log.debug("Only {} ports specified for {} peers", (Object)peerPorts.length, (Object)this.count);
            }
        }
        return peerPorts;
    }

    @Override
    public void execute() throws InterruptedException {
        List<AKeyPair> keyPairList = this.getPeerKeyPairs(this.count);
        int[] peerPorts = this.getPeerPorts();
        this.inform("Starting local test network with " + this.count + " peer(s)");
        List<Server> servers = this.launchLocalPeers(keyPairList, peerPorts);
        int n = servers.size();
        this.launchRestAPI(servers.get(0));
        this.informSuccess("Started: " + n + " local peer" + (n > 1 ? "s" : "") + " launched");
        this.cli().notifyStartup();
        servers.get(0).waitForShutdown();
        this.informWarning("Peer shutdown complete");
    }

    public List<Server> launchLocalPeers(List<AKeyPair> keyPairList, int[] peerPorts) throws InterruptedException {
        List keyList = keyPairList.stream().map(kp -> kp.getAccountKey()).collect(Collectors.toList());
        State genesisState = Init.createState(keyList);
        try {
            return API.launchLocalPeers(keyPairList, (State)genesisState, (int[])peerPorts);
        }
        catch (PeerException e) {
            throw new CLIError(78, "Failed to launch peer(s) : " + e.getMessage(), e);
        }
    }

    public RESTServer launchRestAPI(Server server) {
        RESTServer restServer = RESTServer.create((Server)server);
        if (this.apiPort > 0) {
            log.debug("Requesting REST API on port " + this.apiPort);
        }
        restServer.start(Integer.valueOf(this.apiPort));
        return restServer;
    }
}

