/*
 * Decompiled with CFR 0.152.
 */
package convex.cli.key;

import convex.cli.CLIError;
import convex.cli.key.AKeyCommand;
import convex.cli.key.Key;
import convex.core.crypto.AKeyPair;
import convex.core.crypto.BIP39;
import convex.core.crypto.PEMTools;
import convex.core.crypto.SLIP10;
import convex.core.data.Blob;
import convex.core.exceptions.BadFormatException;
import convex.core.util.FileUtils;
import java.io.IOException;
import org.bouncycastle.util.Arrays;
import picocli.CommandLine;

@CommandLine.Command(name="import", description={"Import key pairs to the keystore."})
public class KeyImport
extends AKeyCommand {
    @CommandLine.ParentCommand
    protected Key keyParent;
    @CommandLine.Option(names={"-i", "--import-file"}, description={"Import file for the the keypair. Use '-' for STDIN."})
    private String importFilename;
    @CommandLine.Option(names={"-t", "--text"}, description={"Text string to import."})
    private String importText;
    @CommandLine.Option(names={"--passphrase"}, description={"Passphrase for BIP39 or encrypted PEM imported key"})
    private String importPassphrase;
    @CommandLine.Option(names={"--type"}, description={"Type of file imported. Supports: pem, seed, bip39. Will attempt to autodetect unless strict security is enabled"})
    private String type;
    @CommandLine.Option(names={"--path"}, defaultValue="m/44/864/0/0/0", description={"Derivation path for SLIP-0010 when using BIP39. Default: ${DEFAULT-VALUE}"})
    private String path;
    @CommandLine.Option(names={"-p", "--keypass"}, defaultValue="${env:CONVEX_KEY_PASSWORD}", scope=CommandLine.ScopeType.INHERIT, description={"Key pair password for imported key. Can specify with CONVEX_KEY_PASSWORD."})
    protected char[] keyPassword;

    public AKeyPair importKeyPair() {
        if (this.importFilename != null && this.importFilename.length() > 0) {
            if (this.importText != null) {
                throw new CLIError(64, "Please provide either --import-file or --text, not both!");
            }
            try {
                this.importText = FileUtils.loadFileAsString((String)this.importFilename);
            }
            catch (IOException e) {
                throw new CLIError("Unable to import key file", e);
            }
        }
        if (this.importText == null || this.importText.length() == 0) {
            this.showUsage();
            return null;
        }
        Blob hex = Blob.parse((String)this.importText.trim());
        if (this.type == null) {
            if (this.isParanoid()) {
                this.informError("Not permitted to infer key import type in strict mode");
                return null;
            }
            this.inform("No import type specified, attempting to auto-detect");
            if (hex != null) {
                if (hex.count() == 32L) {
                    this.type = "seed";
                    this.inform("Detected type 'seed'");
                } else if (hex.count() == 64L) {
                    this.type = "bip39";
                }
            }
        }
        AKeyPair keyPair = null;
        if ("seed".equals(this.type)) {
            if (hex == null) {
                throw new CLIError(65, "'seed' import type requires a hex private key seed");
            }
            if (hex.count() != 32L) {
                throw new CLIError(65, "32 byte hex Ed25519 seed expected as input");
            }
            keyPair = AKeyPair.create((Blob)hex.toFlatBlob());
        } else if ("bip39".equals(this.type)) {
            if (hex == null) {
                if (this.importPassphrase == null) {
                    this.importPassphrase = new String(this.readPassword("Enter passphrase for imported BIP39 memonic: "));
                }
                hex = BIP39.getSeed((String)this.importText, (String)this.importPassphrase);
            }
            keyPair = SLIP10.deriveKeyPair((Blob)hex, (String)this.path);
        } else if ("pem".equals(this.type)) {
            if (this.importPassphrase == null) {
                this.importPassphrase = new String(this.readPassword("Enter passphrase for imported PEM key: "));
            }
            try {
                keyPair = PEMTools.decryptPrivateKeyFromPEM((String)this.importText, (char[])this.importPassphrase.toCharArray());
            }
            catch (BadFormatException e) {
                throw new CLIError(65, "Cannot decode PEM. File may be corrupt or wrong passphrase used.", e);
            }
        }
        if (keyPair == null) {
            throw new CLIError("Unable to import keypair");
        }
        return keyPair;
    }

    @Override
    public void execute() {
        AKeyPair keyPair = this.importKeyPair();
        if (keyPair == null) {
            return;
        }
        if (this.keyPassword == null) {
            this.keyPassword = this.readPassword("Enter password for imported key: ");
        }
        if (this.storeMixin.ensureKeyStore() == null) {
            throw new CLIError("Key store specified for import does not exist");
        }
        this.storeMixin.addKeyPairToStore(keyPair, this.keyPassword);
        Arrays.fill((char[])this.keyPassword, (char)'x');
        this.storeMixin.saveKeyStore();
        this.println(keyPair.getAccountKey().toHexString());
    }
}

