/*
 * Decompiled with CFR 0.152.
 */
package convex.cli.account;

import convex.api.Convex;
import convex.cli.CLIError;
import convex.cli.account.AAccountCommand;
import convex.cli.account.Account;
import convex.core.Result;
import convex.core.cvm.Address;
import convex.core.cvm.Symbols;
import convex.core.data.ACell;
import convex.core.data.List;
import picocli.CommandLine;

@CommandLine.Command(name="info", mixinStandardHelpOptions=true, description={"Get account information."})
public class AccountInformation
extends AAccountCommand {
    @CommandLine.ParentCommand
    private Account accountParent;
    @CommandLine.Parameters(paramLabel="address", description={"Address of the account to get information."})
    private String addressValue;

    @Override
    public void execute() throws InterruptedException {
        if (this.addressValue == null) {
            this.informWarning("You need to provide an address / account number to get information");
            this.showUsage();
            return;
        }
        Address address = Address.parse((String)this.addressValue);
        if (address == null) {
            throw new CLIError(65, "Address cannot be parsed.");
        }
        Convex convex = this.connect();
        List queryCommand = List.of((Object[])new Object[]{Symbols.ACCOUNT, address});
        Result result = convex.querySync((ACell)queryCommand);
        this.printResult(result);
    }
}

