/*
 * Decompiled with CFR 0.152.
 */
package convex.cli.key;

import convex.cli.CLIError;
import convex.cli.key.AKeyCommand;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Enumeration;
import java.util.HashSet;
import picocli.CommandLine;

@CommandLine.Command(name="delete", mixinStandardHelpOptions=false, description={"Delete key(s) from the keystore. Use with caution"})
public class KeyDelete
extends AKeyCommand {
    static final String WILD = "+";
    @CommandLine.Parameters(paramLabel="keys", description={"Key(s) to delete. Should be a hex prefix of a specific key, or trailing '+' as a wildcard"})
    private String[] keys;

    protected void deleteEntry(String alias) throws KeyStoreException {
        this.storeMixin.getKeystore().deleteEntry(alias);
        this.inform("Deleting Key: " + alias);
    }

    @Override
    public void execute() {
        if (this.keys == null || this.keys.length == 0) {
            this.showUsage();
            return;
        }
        KeyStore keyStore = this.storeMixin.ensureKeyStore();
        if (keyStore == null) {
            throw new CLIError("Keystore does not exist. Specify a valid --keystore or use `convex key gen` to create one.");
        }
        HashSet<String> toDelete = new HashSet<String>();
        for (String argKey : this.keys) {
            String key = argKey.trim();
            if (key.startsWith("0x")) {
                key = key.substring(2);
            }
            if (key.length() == 0) {
                throw new CLIError(65, "Empty key specified?");
            }
            boolean wild = key.endsWith(WILD);
            if (wild) {
                key = key.substring(0, key.length() - WILD.length());
            }
            this.inform(3, "Looking for keys to delete like: " + key);
            String found = null;
            try {
                Enumeration<String> aliases = keyStore.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    if (!alias.startsWith(key)) continue;
                    if (wild) {
                        toDelete.add(alias);
                        continue;
                    }
                    if (found != null) {
                        throw new CLIError("Duplicate keys found for prefix: " + argKey);
                    }
                    found = alias;
                }
            }
            catch (KeyStoreException e) {
                throw new CLIError("Unexpected error reading keystore", e);
            }
            if (found == null) continue;
            toDelete.add(found);
        }
        if (toDelete.isEmpty()) {
            this.informWarning("No matching keys found");
        } else {
            for (String s : toDelete) {
                try {
                    this.deleteEntry(s);
                }
                catch (KeyStoreException e) {
                    throw new CLIError("Unable to remove key: " + s, e);
                }
            }
        }
        this.storeMixin.saveKeyStore();
    }
}

