/*
 * Decompiled with CFR 0.152.
 */
package convex.cli.client;

import convex.api.Convex;
import convex.cli.CLIError;
import convex.cli.client.AClientCommand;
import convex.core.Result;
import convex.core.cvm.Address;
import convex.core.cvm.transactions.Invoke;
import convex.core.data.ACell;
import convex.core.data.Format;
import convex.core.lang.Reader;
import convex.core.util.FileUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="transact", mixinStandardHelpOptions=true, description={"Execute a user transaction on the Convex network."})
public class Transact
extends AClientCommand {
    protected static final Logger log = LoggerFactory.getLogger(Transact.class);
    @CommandLine.Option(names={"-o", "--output-file"}, description={"Output file for the transaction instead of execution. Use '-' for STDOUT."})
    private String outputFilename;
    @CommandLine.Parameters(paramLabel="transactionCommand", description={"Transaction Command"})
    private String transactionCode;

    @Override
    public void execute() throws InterruptedException {
        Address a = this.getUserAddress();
        if (a == null) {
            throw new CLIError(64, "You must specify a valid origin address for the transaction.");
        }
        Convex convex = this.connectTransact();
        Address address = convex.getAddress();
        log.trace("Executing transaction: '{}'\n", (Object)this.transactionCode);
        ACell message = Reader.read((String)this.transactionCode);
        Invoke transaction = Invoke.create((Address)address, (long)0L, (ACell)message);
        if (this.outputFilename == null) {
            this.ensureKeyPair(convex);
            Result result = convex.transactSync((ACell)transaction);
            this.mainParent.printResult(result);
        } else {
            String output = Format.encodeMultiCell((ACell)transaction, (boolean)true).toHexString();
            if ("-".equals(this.outputFilename.trim())) {
                this.println(output);
            } else {
                try {
                    FileUtils.writeFileAsString((Path)Paths.get(this.outputFilename, new String[0]), (String)output);
                }
                catch (IOException e) {
                    throw new CLIError("Failed to write output file: " + e.getMessage());
                }
            }
        }
    }
}

