/*
 * Decompiled with CFR 0.152.
 */
package convex.core.lang.impl;

import convex.core.data.ACell;
import convex.core.data.AMap;
import convex.core.data.BlobBuilder;
import convex.core.lang.Context;
import convex.core.lang.impl.ADataFn;

public class MapFn<K extends ACell, T extends ACell>
extends ADataFn<T> {
    private AMap<K, T> map;

    public MapFn(AMap<K, T> m) {
        this.map = m;
    }

    public static <K extends ACell, T extends ACell> MapFn<K, T> wrap(AMap<K, T> m) {
        return new MapFn<K, T>(m);
    }

    @Override
    public Context<T> invoke(Context context, ACell[] args2) {
        T result;
        int n = args2.length;
        if (n == 1) {
            ACell key = args2[0];
            result = this.map.get(key);
        } else if (n == 2) {
            ACell key = args2[0];
            result = this.map.get(key, args2[1]);
        } else {
            return context.withArityError("Expected arity 1 or 2 for map lookup but got: " + n);
        }
        return context.withResult((ACell)result);
    }

    @Override
    public boolean print(BlobBuilder sb, long limit) {
        return this.map.print(sb, limit);
    }
}

