/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.hyperlink;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Logger;
import org.jdesktop.swingx.hyperlink.AbstractHyperlinkAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperlinkAction
extends AbstractHyperlinkAction<URI> {
    private static final Logger LOG = Logger.getLogger(HyperlinkAction.class.getName());
    private Desktop.Action desktopAction;
    private URIVisitor visitor;

    public static HyperlinkAction createHyperlinkAction(URI uri2) {
        Desktop.Action type = HyperlinkAction.isMailURI(uri2) ? Desktop.Action.MAIL : Desktop.Action.BROWSE;
        return HyperlinkAction.createHyperlinkAction(uri2, type);
    }

    public static HyperlinkAction createHyperlinkAction(URI uri2, Desktop.Action type) {
        return new HyperlinkAction(uri2, type);
    }

    private static boolean isMailURI(URI uri2) {
        return uri2 != null && "mailto".equalsIgnoreCase(uri2.getScheme());
    }

    public HyperlinkAction() {
        this(Desktop.Action.BROWSE);
    }

    public HyperlinkAction(Desktop.Action desktopAction) {
        this(null, desktopAction);
    }

    public HyperlinkAction(URI uri2, Desktop.Action desktopAction) {
        if (!Desktop.isDesktopSupported()) {
            throw new UnsupportedOperationException("Desktop API is not supported on the current platform");
        }
        if (desktopAction != Desktop.Action.BROWSE && desktopAction != Desktop.Action.MAIL) {
            throw new IllegalArgumentException("Illegal action type: " + (Object)((Object)desktopAction) + ". Must be BROWSE or MAIL");
        }
        this.desktopAction = desktopAction;
        this.getURIVisitor();
        this.setTarget(uri2);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.getURIVisitor().isEnabled((URI)this.getTarget())) {
            return;
        }
        try {
            this.getURIVisitor().visit((URI)this.getTarget());
            this.setVisited(true);
        }
        catch (IOException e1) {
            this.setVisited(false);
            LOG.fine("cant visit Desktop " + e);
        }
    }

    public Desktop.Action getDesktopAction() {
        return this.desktopAction;
    }

    @Override
    protected void installTarget() {
        if (this.visitor == null) {
            return;
        }
        super.installTarget();
        this.updateEnabled();
    }

    private void updateEnabled() {
        this.setEnabled(this.getURIVisitor().isEnabled((URI)this.getTarget()));
    }

    private URIVisitor getURIVisitor() {
        if (this.visitor == null) {
            this.visitor = this.createURIVisitor();
        }
        return this.visitor;
    }

    private URIVisitor createURIVisitor() {
        return this.getDesktopAction() == Desktop.Action.BROWSE ? new BrowseVisitor() : new MailVisitor();
    }

    private class MailVisitor
    extends URIVisitor {
        private MailVisitor() {
        }

        public void visit(URI uri2) throws IOException {
            if (uri2 == null) {
                Desktop.getDesktop().mail();
            } else {
                Desktop.getDesktop().mail(uri2);
            }
        }

        protected boolean isActionSupported() {
            return Desktop.getDesktop().isSupported(Desktop.Action.MAIL);
        }
    }

    private class BrowseVisitor
    extends URIVisitor {
        private BrowseVisitor() {
        }

        public void visit(URI uri2) throws IOException {
            Desktop.getDesktop().browse(uri2);
        }

        protected boolean isActionSupported() {
            return Desktop.getDesktop().isSupported(Desktop.Action.BROWSE);
        }

        public boolean isEnabled(URI uri2) {
            return uri2 != null && super.isEnabled(uri2);
        }
    }

    private abstract class URIVisitor {
        protected boolean desktopSupported = Desktop.isDesktopSupported();

        private URIVisitor() {
        }

        public boolean isEnabled(URI uri2) {
            return this.desktopSupported && this.isActionSupported();
        }

        public abstract void visit(URI var1) throws IOException;

        protected abstract boolean isActionSupported();
    }
}

