/*
 * Decompiled with CFR 0.152.
 */
package convex.core.util;

import convex.core.data.BlobBuilder;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;

public class Text {
    private static final int WHITESPACE_LENGTH = 32;
    private static String WHITESPACE_32 = "                                ";
    static DecimalFormat balanceFormatter = new DecimalFormat("#,###");
    static DecimalFormat percentFormatter = new DecimalFormat("##.###%");
    static final DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendInstant(3).toFormatter();

    public static String whiteSpace(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Negative whitespace requested!");
        }
        if (length == 0) {
            return "";
        }
        if (length <= 32) {
            return WHITESPACE_32.substring(0, length);
        }
        StringBuilder sb = new StringBuilder(length);
        for (int i = 32; i <= length; i += 32) {
            sb.append(WHITESPACE_32);
        }
        sb.append(Text.whiteSpace(length & 0x1F));
        return sb.toString();
    }

    public static String leftPad(String s, int length) {
        int spaces;
        if (s == null) {
            s = "";
        }
        if ((spaces = length - s.length()) < 0) {
            throw new IllegalArgumentException("String [" + s + "] too long for pad length: " + length);
        }
        return Text.whiteSpace(spaces) + s;
    }

    public static String leftPad(long value, int length) {
        return Text.leftPad(Long.toString(value), length);
    }

    public static String rightPad(String s, int length) {
        int spaces;
        if (s == null) {
            s = "";
        }
        if ((spaces = length - s.length()) < 0) {
            throw new IllegalArgumentException("String [" + s + "] too long for pad length: " + length);
        }
        return s + Text.whiteSpace(spaces);
    }

    public static String rightPad(long value, int length) {
        return Text.rightPad(Long.toString(value), length);
    }

    public static String toFriendlyBalance(long value) {
        return balanceFormatter.format(value);
    }

    public static String toPercentString(double value) {
        return percentFormatter.format(value);
    }

    public static String toFriendlyBalance(double value) {
        return Text.toFriendlyBalance((long)value);
    }

    public static String dateFormat(long timestamp) {
        return formatter.format(Instant.ofEpochMilli(timestamp));
    }

    public static void writeEscapedByte(BlobBuilder sb, byte b) {
        char c = (char)b;
        switch (c) {
            case '\"': {
                sb.append('\\');
                sb.append('\"');
                return;
            }
            case '\\': {
                sb.append('\\');
                sb.append('\\');
                return;
            }
            case '\'': {
                sb.append('\\');
                sb.append('\'');
                return;
            }
            case '\t': {
                sb.append('\\');
                sb.append('t');
                return;
            }
            case '\b': {
                sb.append('\\');
                sb.append('b');
                return;
            }
            case '\n': {
                sb.append('\\');
                sb.append('n');
                return;
            }
            case '\r': {
                sb.append('\\');
                sb.append('r');
                return;
            }
            case '\f': {
                sb.append('\\');
                sb.append('f');
                return;
            }
        }
        sb.append(b);
    }
}

