/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.ACollection;
import convex.core.data.ACountable;
import convex.core.data.AList;
import convex.core.data.AVector;
import convex.core.data.IAssociative;
import convex.core.data.Ref;
import convex.core.data.prim.CVMLong;
import convex.core.lang.RT;
import convex.core.util.Errors;
import convex.core.util.Utils;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class ASequence<T extends ACell>
extends ACollection<T>
implements List<T>,
IAssociative<CVMLong, T> {
    public ASequence(long count) {
        super(count);
    }

    @Override
    public boolean contains(Object o) {
        return this.longIndexOf(o) >= 0L;
    }

    public abstract long longIndexOf(Object var1);

    public abstract long longLastIndexOf(Object var1);

    @Override
    public abstract <R extends ACell> ASequence<R> map(Function<? super T, ? extends R> var1);

    @Override
    public abstract void forEach(Consumer<? super T> var1);

    public abstract void visitElementRefs(Consumer<Ref<T>> var1);

    public <R extends ACell> ASequence<R> flatMap(Function<? super T, ? extends ASequence<R>> mapper) {
        ACollection vals = this.map(mapper);
        ASequence<R> result = (ASequence<R>)this.empty();
        for (ASequence seq : vals) {
            result = result.concat(seq);
        }
        return result;
    }

    public abstract <R extends ACell> ASequence<R> concat(ASequence<R> var1);

    @Override
    public final boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException(Errors.immutable(this));
    }

    public abstract ASequence<T> next();

    @Override
    public T get(int index) {
        return this.get((long)index);
    }

    @Override
    public abstract T get(long var1);

    public T get(ACell key) {
        long ix;
        if (key instanceof CVMLong && (ix = ((CVMLong)key).longValue()) >= 0L && ix < this.count()) {
            return this.get(ix);
        }
        return null;
    }

    @Override
    public ACell get(ACell key, ACell notFound) {
        long ix;
        if (key instanceof CVMLong && (ix = ((CVMLong)key).longValue()) >= 0L && ix < this.count()) {
            return this.get(ix);
        }
        return notFound;
    }

    @Override
    public boolean containsKey(ACell key) {
        long ix;
        return key instanceof CVMLong && (ix = ((CVMLong)key).longValue()) >= 0L && ix < this.count();
    }

    @Override
    public abstract Ref<T> getElementRef(long var1);

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException(Errors.immutable(this));
    }

    @Override
    public ASequence<T> assoc(ACell key, ACell value) {
        CVMLong ix = RT.ensureLong(key);
        if (ix == null) {
            return null;
        }
        return this.assoc(ix.longValue(), value);
    }

    public abstract <R extends ACell> ASequence<R> assoc(long var1, R var3);

    protected void checkRange(long start2, long length) {
        if (start2 < 0L) {
            throw (RuntimeException)Utils.sneakyThrow(new IndexOutOfBoundsException("Negative start: " + start2));
        }
        if (length < 0L) {
            throw (RuntimeException)Utils.sneakyThrow(new IndexOutOfBoundsException("Negative length: " + length));
        }
        if (start2 + length > this.count()) {
            throw (RuntimeException)Utils.sneakyThrow(new IndexOutOfBoundsException("End out of bounds: " + start2 + length));
        }
    }

    @Override
    public final void add(int index, T element) {
        throw new UnsupportedOperationException(Errors.immutable(this));
    }

    @Override
    public final T remove(int index) {
        throw new UnsupportedOperationException(Errors.immutable(this));
    }

    @Override
    public ACell[] toCellArray() {
        int n = Utils.checkedInt(this.count());
        ACell[] cells = new ACell[n];
        for (int i = 0; i < n; ++i) {
            cells[i] = this.get(i);
        }
        return cells;
    }

    @Override
    public abstract <R extends ACell> ASequence<R> conj(R var1);

    @Override
    public abstract ASequence<T> slice(long var1, long var3);

    public abstract AList<T> cons(T var1);

    public abstract <R extends ACell> AVector<R> subVector(long var1, long var3);

    @Override
    public final List<T> subList(int fromIndex, int toIndex) {
        long start2 = fromIndex;
        long end = toIndex;
        ACountable result = this.slice(start2, end);
        if (result == null) {
            throw new IndexOutOfBoundsException(Errors.badRange(start2, end));
        }
        return result;
    }

    protected abstract ListIterator<T> listIterator(long var1);

    public abstract ASequence<T> reverse();
}

