/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.Ref;
import convex.core.data.VectorLeaf;
import convex.core.data.Vectors;
import convex.core.exceptions.TODOException;
import convex.core.util.Errors;
import convex.core.util.Utils;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;

public abstract class AMapEntry<K extends ACell, V extends ACell>
extends AVector<ACell>
implements Map.Entry<K, V> {
    public AMapEntry(long count) {
        super(2L);
    }

    @Override
    public abstract ACell get(long var1);

    @Override
    public final AVector<ACell> appendChunk(VectorLeaf<ACell> listVector) {
        throw new IllegalArgumentException("Can't append chunk to a MapEntry of size: 2");
    }

    @Override
    public final VectorLeaf<ACell> getChunk(long offset) {
        return this.toVector().getChunk(offset);
    }

    @Override
    public final boolean isFullyPacked() {
        return false;
    }

    @Override
    public abstract int getRefCount();

    @Override
    public abstract <R extends ACell> Ref<R> getRef(int var1);

    @Override
    public abstract K getKey();

    @Override
    public abstract V getValue();

    @Override
    public final V setValue(V value) {
        throw new UnsupportedOperationException(Errors.immutable(this));
    }

    @Override
    public abstract boolean isCanonical();

    @Override
    public AVector<ACell> append(ACell value) {
        return this.toVector().append(value);
    }

    @Override
    public Spliterator<ACell> spliterator(long position) {
        return this.toVector().spliterator(position);
    }

    @Override
    public ListIterator<ACell> listIterator(long index) {
        return this.toVector().listIterator(index);
    }

    @Override
    public ListIterator<ACell> listIterator() {
        return this.toVector().listIterator();
    }

    @Override
    public Iterator<ACell> iterator() {
        return this.toVector().iterator();
    }

    @Override
    public long longIndexOf(Object o) {
        return this.toVector().longIndexOf(o);
    }

    @Override
    public long longLastIndexOf(Object o) {
        return this.toVector().longLastIndexOf(o);
    }

    @Override
    public long commonPrefixLength(AVector<ACell> b) {
        if (b == this) {
            return 2L;
        }
        long bc = b.count();
        if (bc == 0L) {
            return 0L;
        }
        if (!Utils.equals((ACell)this.getKey(), (ACell)b.get(0))) {
            return 0L;
        }
        if (bc == 1L) {
            return 1L;
        }
        if (!Utils.equals((ACell)this.getValue(), (ACell)b.get(1))) {
            return 1L;
        }
        return 2L;
    }

    protected abstract AMapEntry<K, V> withKey(K var1);

    protected abstract AMapEntry<K, V> withValue(V var1);

    @Override
    public AVector<ACell> next() {
        return Vectors.of(this.getValue());
    }

    @Override
    public abstract int encode(byte[] var1, int var2);

    @Override
    public final ACell set(int index, ACell element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean anyMatch(Predicate<? super ACell> pred) {
        return this.toVector().anyMatch(pred);
    }

    @Override
    public boolean allMatch(Predicate<? super ACell> pred) {
        return this.toVector().allMatch(pred);
    }

    @Override
    public void forEach(Consumer<? super ACell> action) {
        action.accept((ACell)this.getKey());
        action.accept((ACell)this.getValue());
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new TODOException();
    }
}

