/*
 * Decompiled with CFR 0.152.
 */
package convex.core.crypto;

import convex.core.crypto.ASignature;
import convex.core.crypto.Ed25519KeyPair;
import convex.core.crypto.Providers;
import convex.core.data.ACell;
import convex.core.data.AccountKey;
import convex.core.data.Blob;
import convex.core.data.Hash;
import convex.core.data.SignedData;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;

public abstract class AKeyPair {
    public abstract AccountKey getAccountKey();

    public abstract Blob getEncodedPrivateKey();

    public abstract <R extends ACell> SignedData<R> signData(R var1);

    public abstract boolean equals(Object var1);

    public abstract ASignature sign(Hash var1);

    public static AKeyPair createSeeded(long seed) {
        return Ed25519KeyPair.createSeeded(seed);
    }

    public static AKeyPair create(AccountKey publicKey, Blob encodedPrivateKey) {
        return Ed25519KeyPair.create(publicKey, encodedPrivateKey);
    }

    public static AKeyPair generate() {
        return Ed25519KeyPair.generate();
    }

    public static AKeyPair create(byte[] keyMaterial) {
        return Ed25519KeyPair.create(keyMaterial);
    }

    public abstract PrivateKey getPrivate();

    public abstract PublicKey getPublic();

    public String toString() {
        return this.getAccountKey() + ":" + this.getEncodedPrivateKey();
    }

    public abstract KeyPair getJCAKeyPair();

    static {
        Providers.init();
    }
}

