/*
 * Decompiled with CFR 0.152.
 */
package convex.cli;

import convex.api.Convex;
import convex.cli.CLIError;
import convex.cli.Helpers;
import convex.cli.Main;
import convex.cli.output.RecordOutput;
import convex.cli.peer.SessionItem;
import convex.core.Result;
import convex.core.data.ABlob;
import convex.core.data.AVector;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="status", mixinStandardHelpOptions=true, description={"Reports on the current status of the network."})
public class Status
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(Status.class);
    @CommandLine.ParentCommand
    protected Main mainParent;
    @CommandLine.Option(names={"--port"}, description={"Port number to connect or create a peer."})
    private int port = 0;
    @CommandLine.Option(names={"--host"}, defaultValue="localhost", description={"Hostname to connect to a peer. Default: ${DEFAULT-VALUE}"})
    private String hostname;
    @CommandLine.Option(names={"-t", "--timeout"}, description={"Timeout in miliseconds."})
    private long timeout = 5000L;

    @Override
    public void run() {
        if (this.port == 0) {
            try {
                SessionItem item = Helpers.getSessionItem(this.mainParent.getSessionFilename());
                this.port = item.getPort();
            }
            catch (IOException e) {
                log.warn("Cannot load the session control file");
            }
        }
        if (this.port == 0) {
            log.warn("Cannot find a local port or you have not set a valid port number");
            return;
        }
        Convex convex = null;
        convex = this.mainParent.connectAsPeer(0);
        try {
            Result result = convex.requestStatus().get(this.timeout, TimeUnit.MILLISECONDS);
            AVector resultVector = (AVector)result.getValue();
            ABlob stateHash = (ABlob)resultVector.get(1);
            RecordOutput output = new RecordOutput();
            output.addField("State hash", stateHash.toString());
            this.mainParent.printRecord(output);
        }
        catch (Exception e) {
            throw new CLIError("Error getting network status", e);
        }
    }
}

