/*
 * Decompiled with CFR 0.152.
 */
package convex.cli;

import convex.cli.Key;
import convex.cli.Main;
import convex.core.crypto.AKeyPair;
import convex.core.crypto.PFXTools;
import convex.core.util.Utils;
import java.security.KeyStore;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="generate", aliases={"gen"}, mixinStandardHelpOptions=true, description={"Generate private key pairs in the currently configured keystore. Will create a keystore if it does not exist."})
public class KeyGenerate
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(KeyGenerate.class);
    @CommandLine.ParentCommand
    protected Key keyParent;
    @CommandLine.Parameters(paramLabel="count", defaultValue="1", description={"Number of keys to generate. Default: ${DEFAULT-VALUE}"})
    private int count;

    @Override
    public void run() {
        Main mainParent = this.keyParent.mainParent;
        if (this.count < 0) {
            log.warn("Unlikely count of keys to generate: " + this.count);
            this.count = 0;
        }
        log.debug("Generating {} keys", (Object)this.count);
        String password = mainParent.getPassword();
        try {
            KeyStore ks = mainParent.loadKeyStore(true);
            List<AKeyPair> keyPairList = mainParent.generateKeyPairs(this.count);
            for (int index = 0; index < this.count; ++index) {
                AKeyPair kp = keyPairList.get(index);
                String publicKeyHexString = kp.getAccountKey().toHexString();
                mainParent.println(publicKeyHexString);
                PFXTools.setKeyPair(ks, kp, password);
            }
            log.info(this.count + " keys successfully generated");
            mainParent.saveKeyStore();
        }
        catch (Throwable e) {
            throw (RuntimeException)Utils.sneakyThrow(e);
        }
    }
}

