/*
 * Decompiled with CFR 0.152.
 */
package convex.cli;

import convex.cli.Key;
import convex.cli.Main;
import convex.core.crypto.AKeyPair;
import convex.core.crypto.PEMTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="export", mixinStandardHelpOptions=true, description={"Export a key pair from the keystore to a PEM file."})
public class KeyExport
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(KeyExport.class);
    @CommandLine.ParentCommand
    protected Key keyParent;
    @CommandLine.Option(names={"--public-key"}, description={"Hex string of the public key in the Keystore to use for the peer.%nYou only need to enter in the first distinct hex values of the public key.%nFor example: 0xf0234 or f0234"})
    private String keystorePublicKey;
    @CommandLine.Option(names={"--export-password"}, description={"Password of the exported key."})
    private String exportPassword;

    @Override
    public void run() {
        Main mainParent = this.keyParent.mainParent;
        if (this.keystorePublicKey == null) {
            log.warn("You need to provide at least --public-key parameter");
            return;
        }
        if (this.exportPassword == null || this.exportPassword.length() == 0) {
            log.warn("You should provide an export password '--export-password' for the exported key");
            return;
        }
        String publicKey = this.keystorePublicKey;
        AKeyPair keyPair = mainParent.loadKeyFromStore(publicKey);
        String pemText = PEMTools.encryptPrivateKeyToPEM(keyPair.getPrivate(), this.exportPassword.toCharArray());
        mainParent.println(pemText);
    }
}

