/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.components.spinner;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSpinnerUI;
import mdlaf.animation.MaterialUIMovement;
import mdlaf.components.button.MaterialButtonsComponentsUI;
import mdlaf.utils.MaterialColors;

public class MaterialSpinnerUI
extends BasicSpinnerUI {
    protected JButton upArrowButton;
    protected JButton downArrowButton;
    protected Color spinnerDisableBackground = MaterialColors.COSMO_DARK_GRAY;
    protected Color spinnerBackground;

    public static ComponentUI createUI(JComponent c) {
        return new MaterialSpinnerUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.spinnerBackground = UIManager.getColor("Spinner.background");
        this.spinnerDisableBackground = UIManager.getColor("Spinner.disabledBackground");
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.setCursor(Cursor.getDefaultCursor());
        super.uninstallUI(c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
    }

    @Override
    protected Component createNextButton() {
        JButton button;
        Icon icon = UIManager.getIcon("Spinner.nextButtonIcon");
        this.upArrowButton = button = this.configureLocalButton(icon);
        this.installNextButtonListeners(button);
        return button;
    }

    @Override
    protected Component createPreviousButton() {
        Icon icon = UIManager.getIcon("Spinner.previousButtonIcon");
        JButton button = this.configureLocalButton(icon);
        this.installPreviousButtonListeners(button);
        this.downArrowButton = button;
        return button;
    }

    protected JButton configureLocalButton(Icon icon) {
        ArrowButtonSpinner arrowButton = new ArrowButtonSpinner(icon);
        return arrowButton;
    }

    protected class ArrowButtonSpinner
    extends JButton {
        public ArrowButtonSpinner(Icon icon) {
            super(icon);
            this.setUI(new SpinnerButtonUI());
        }

        @Override
        public void updateUI() {
            this.setUI(new SpinnerButtonUI());
        }

        protected class SpinnerButtonUI
        extends MaterialButtonsComponentsUI {
            protected SpinnerButtonUI() {
            }

            @Override
            public void installUI(JComponent c) {
                super.installUI(c);
                this.mouseHoverEnabled = UIManager.getBoolean("Spinner.mouseHoverEnabled");
                this.background = UIManager.getColor("Spinner.arrowButtonBackground");
                this.disabledBackground = MaterialSpinnerUI.this.spinnerDisableBackground;
                LookAndFeel.installColors(this.button, "Spinner.arrowButtonBackground", "Button.foreground");
                this.button.setBorder(BorderFactory.createLineBorder(this.background));
                if (this.mouseHoverEnabled.booleanValue()) {
                    this.mouseHover = MaterialUIMovement.getMovement(this.button, UIManager.getColor("Spinner.mouseHoverColor"));
                    this.button.addMouseListener(this.mouseHover);
                }
            }

            @Override
            protected void paintFocusRing(Graphics g, JButton b) {
                g.setColor(this.background);
            }

            @Override
            protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
            }
        }
    }
}

