/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JWindow;

public class Toast
extends JWindow {
    public static final Color SUCCESS = new Color(100, 150, 0);
    public static final Color FAIL = new Color(150, 50, 50);
    public static final Color INFO = new Color(50, 100, 150);

    public Toast(JComponent parent, JComponent component, Color color) {
        this.setLayout(new BorderLayout());
        this.setBackground(color);
        this.getContentPane().setBackground(color);
        this.add(component);
        Point pp = parent.getLocationOnScreen();
        int px = (int)pp.getX();
        int py = (int)pp.getY();
        int pw = parent.getWidth();
        int ph = parent.getHeight();
        int h = 50;
        this.setLocation(px, py + ph - h);
        this.setSize(pw, h);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Toast.this.setShape(new RoundRectangle2D.Float(0.0f, 0.0f, Toast.this.getWidth(), Toast.this.getHeight(), 16.0f, 16.0f));
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    private void doDisplay(long millis) {
        this.setVisible(true);
        long start2 = System.currentTimeMillis();
        new Thread(() -> {
            try {
                long time = start2;
                while (time < start2 + millis) {
                    Thread.sleep(100L);
                    time = System.currentTimeMillis();
                    double opac = Math.min(1.0, Math.max(0.0, 2.0 * (1.0 - (double)(time - start2) / (double)millis)));
                    this.setOpacity((float)opac);
                }
            }
            catch (InterruptedException e) {
                this.setOpacity(0.0f);
                Thread.currentThread().interrupt();
            }
            finally {
                this.setVisible(false);
            }
        }).start();
    }

    public static void display(JComponent parent, JComponent component, Color colour) {
        Toast toast = new Toast(parent, component, colour);
        toast.doDisplay(2000L);
    }

    public static void display(JComponent parent, JComponent component) {
        Toast.display(parent, component, SUCCESS);
    }

    public static void display(JComponent parent, String message, Color colour) {
        JTextArea ta = new JTextArea(message);
        ta.setBackground(null);
        ta.setEditable(false);
        Toast.display(parent, ta, colour);
    }
}

