/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.ASequence;
import convex.core.data.AVector;
import convex.core.data.VectorLeaf;
import convex.core.data.Vectors;
import convex.core.util.Utils;

public class VectorBuilder<T extends ACell> {
    private static final int CHUNK_LENGTH = 16;
    protected AVector<T> acc = VectorLeaf.EMPTY;
    protected final ACell[] tail = new ACell[16];
    protected long count = 0L;

    public VectorBuilder() {
    }

    public VectorBuilder(ASequence<T> seq) {
        this();
        this.concat(seq);
    }

    private int spare() {
        return (int)(16L - (this.count - this.acc.count()));
    }

    private int arrayPos() {
        return Utils.checkedInt(this.count - this.acc.count());
    }

    public VectorBuilder<T> append(T a) {
        return this;
    }

    public VectorBuilder<T> concat(ASequence<T> b) {
        long blen = b.count();
        if (blen == 0L) {
            return this;
        }
        long spare = this.spare();
        if (blen <= spare) {
            int pos = this.arrayPos();
            int i = 0;
            while ((long)i < blen) {
                this.tail[pos++] = b.get(i);
                ++i;
            }
            this.count += blen;
            if (blen == spare) {
                this.completeChunk();
            }
        } else {
            this.concat((ASequence<T>)b.slice(0L, spare));
            for (long off = spare; off < blen; off += 16L) {
                long take = Math.min(16L, blen - off);
                this.concat((ASequence<T>)b.slice(off, off + take));
            }
        }
        return this;
    }

    public VectorBuilder<T> conj(T b) {
        int pos = this.arrayPos();
        this.tail[pos++] = b;
        ++this.count;
        if (pos == 16) {
            this.completeChunk();
        }
        return this;
    }

    private void completeChunk() {
        if (this.tail.length != 16) {
            throw new Error("tail not complete! Has length: " + this.tail.length);
        }
        VectorLeaf b = VectorLeaf.create(this.tail, 0, 16);
        this.acc = this.acc.concat((ASequence)b);
    }

    public AVector<T> toVector() {
        ASequence result = this.acc;
        int tlen = (int)(this.count - this.acc.count());
        if (tlen == 0) {
            return this.acc;
        }
        if ((result = ((AVector)result).concat((ASequence)Vectors.create(this.tail, 0, tlen))).count() != this.count) {
            throw new Error("Invalid count!!");
        }
        return result;
    }

    public long count() {
        return this.count;
    }

    public boolean check(long limit) {
        return this.count <= limit;
    }

    public void clear() {
        this.acc = Vectors.empty();
        this.count = 0L;
    }
}

