/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.animation;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import mdlaf.animation.MaterialMouseHover;

class MaterialUIStaticMovement
implements MaterialMouseHover {
    private Color before;
    private Color after;
    private Color strongOnClick;

    public MaterialUIStaticMovement(Color before, Color after, Color strongOnClick) {
        this.before = before;
        this.after = after;
        this.strongOnClick = strongOnClick;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.setColorComponent(e, this.after);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e == null) {
            return;
        }
        this.setColorComponent(e, this.strongOnClick);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e == null) {
            return;
        }
        this.setColorComponent(e, this.before);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.setColorComponent(e, this.after).setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setColorComponent(e, this.before).setCursor(Cursor.getDefaultCursor());
    }

    private JComponent setColorComponent(MouseEvent e, Color colorComponent) {
        JComponent component = (JComponent)e.getSource();
        if (component.isEnabled()) {
            component.setBackground(colorComponent);
        }
        return component;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public boolean isRunning() {
        return false;
    }
}

