/*
 * Decompiled with CFR 0.152.
 */
package convex.core.transactions;

import convex.core.data.ACell;
import convex.core.data.Address;
import convex.core.data.BlobBuilder;
import convex.core.data.Format;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.AOp;
import convex.core.lang.Context;
import convex.core.lang.RT;
import convex.core.lang.Reader;
import convex.core.transactions.ATransaction;
import convex.core.util.Utils;
import java.nio.ByteBuffer;

public class Invoke
extends ATransaction {
    protected final ACell command;

    protected Invoke(Address address, long sequence, ACell args) {
        super(address, sequence);
        this.command = args;
    }

    public static Invoke create(Address address, long sequence, ACell command) {
        return new Invoke(address, sequence, command);
    }

    public static Invoke create(Address address, long sequence, String command) {
        return Invoke.create(address, sequence, Reader.read(command));
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = -48;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = super.encodeRaw(bs, pos);
        pos = Format.write(bs, pos, this.command);
        return pos;
    }

    public Object getCommand() {
        return this.command;
    }

    public static Invoke read(ByteBuffer bb) throws BadFormatException {
        Address address = Address.create(Format.readVLCLong(bb));
        long sequence = Format.readVLCLong(bb);
        Object args = Format.read(bb);
        return Invoke.create(address, sequence, args);
    }

    @Override
    public <T extends ACell> Context<T> apply(Context<?> context) {
        Context<Object> ctx = context;
        ctx = this.command instanceof AOp ? ctx.run((AOp)this.command) : ctx.run(this.command);
        return ctx;
    }

    @Override
    public int estimatedEncodingSize() {
        return 163;
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public boolean print(BlobBuilder sb, long limit) {
        sb.append("{");
        sb.append(":invoke ");
        if (!RT.print(sb, this.command, limit)) {
            return false;
        }
        sb.append('}');
        return sb.check(limit);
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.command instanceof AOp) {
            ((AOp)this.command).validateCell();
        } else if (!Format.isCanonical(this.command)) {
            throw new InvalidDataException("Non-canonical object as command?", this);
        }
    }

    @Override
    public Long getMaxJuice() {
        return 1000000L;
    }

    @Override
    public int getRefCount() {
        return Utils.refCount(this.command);
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        return Utils.getRef(this.command, i);
    }

    @Override
    public Invoke updateRefs(IRefFunction func) {
        ACell newCommand = Utils.updateRefs(this.command, func);
        if (newCommand == this.command) {
            return this;
        }
        return Invoke.create(this.origin, this.getSequence(), newCommand);
    }

    @Override
    public Invoke withSequence(long newSequence) {
        if (newSequence == this.sequence) {
            return this;
        }
        return Invoke.create(this.origin, newSequence, this.command);
    }

    @Override
    public Invoke withOrigin(Address newAddress) {
        if (newAddress == this.origin) {
            return this;
        }
        return Invoke.create(newAddress, this.sequence, this.command);
    }

    @Override
    public byte getTag() {
        return -48;
    }
}

