/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ABlob;
import convex.core.data.ACountable;
import convex.core.data.BlobBuilder;
import convex.core.data.Ref;
import convex.core.data.StringShort;
import convex.core.data.Strings;
import convex.core.data.prim.CVMChar;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.util.Utils;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

public abstract class AString
extends ACountable<CVMChar>
implements Comparable<AString> {
    protected long length;

    protected AString(long length) {
        this.length = length;
    }

    @Override
    public AType getType() {
        return Types.STRING;
    }

    @Override
    public boolean print(BlobBuilder sb, long limit) {
        if (!sb.check(limit - this.count())) {
            return false;
        }
        sb.append('\"');
        sb.append(this);
        sb.append('\"');
        return sb.check(limit);
    }

    @Override
    public long count() {
        return this.length;
    }

    public StringShort empty() {
        return Strings.EMPTY;
    }

    public abstract int charAt(long var1);

    public int intAt(long index) {
        int r = 0;
        for (int i = 0; i < 4; ++i) {
            r = (r >> 8) + (0xFF & this.byteAt(index + (long)i));
        }
        return r;
    }

    public abstract byte byteAt(long var1);

    @Override
    public CVMChar get(long i) {
        return CVMChar.create(this.charAt((int)i));
    }

    @Override
    public Ref<CVMChar> getElementRef(long i) {
        return this.get(i).getRef();
    }

    @Override
    public abstract int compareTo(AString var1);

    @Override
    public final String toString() {
        int n = Utils.checkedInt(this.count());
        ByteBuffer bb = ByteBuffer.allocate(n);
        this.writeToBuffer(bb);
        bb.flip();
        int cn = Math.min(4096, n);
        CharBuffer cb = CharBuffer.allocate(cn);
        CharsetDecoder dec = Strings.getDecoder();
        StringBuilder sb = new StringBuilder(cn);
        while (bb.hasRemaining()) {
            CoderResult cr = dec.decode(bb, cb, false);
            cb.flip();
            sb.append(cb.toString());
            cb.clear();
            if (cr != CoderResult.UNDERFLOW) continue;
            break;
        }
        dec.decode(bb, cb, true);
        cb.flip();
        sb.append(cb.toString());
        cb.clear();
        return sb.toString();
    }

    @Override
    public AString toCVMString(long limit) {
        if (limit < this.count()) {
            return null;
        }
        return this;
    }

    public AString append(AString b) {
        if (this.length == 0L) {
            return b;
        }
        long n = b.count();
        if (n == 0L) {
            return this;
        }
        return Strings.create(this.toBlob().append(b.toBlob()));
    }

    protected abstract void writeToBuffer(ByteBuffer var1);

    public abstract AString subSequence(long var1, long var3);

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = 48;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public abstract int encodeRaw(byte[] var1, int var2);

    public abstract int encodeRawData(byte[] var1, int var2);

    @Override
    public final byte getTag() {
        return 48;
    }

    @Override
    public final int hashCode() {
        return this.toBlob().hashCode();
    }

    public abstract ABlob toBlob();

    public AString append(String string) {
        return this.append(Strings.create(string));
    }
}

