/*
 * Decompiled with CFR 0.152.
 */
package convex.api;

import convex.api.Convex;
import convex.core.Result;
import convex.core.State;
import convex.core.crypto.AKeyPair;
import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.Address;
import convex.core.data.Hash;
import convex.core.data.Ref;
import convex.core.data.SignedData;
import convex.core.exceptions.MissingDataException;
import convex.core.lang.RT;
import convex.core.store.AStore;
import convex.core.store.Stores;
import convex.core.transactions.ATransaction;
import convex.core.util.Utils;
import convex.net.Connection;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvexRemote
extends Convex {
    protected Connection connection;
    private static final Logger log = LoggerFactory.getLogger(ConvexRemote.class.getName());

    public InetSocketAddress getRemoteAddress() {
        return this.connection.getRemoteAddress();
    }

    protected ConvexRemote(Address address, AKeyPair keyPair) {
        super(address, keyPair);
    }

    protected void connectToPeer(InetSocketAddress peerAddress, AStore store) throws IOException, TimeoutException {
        this.setConnection(Connection.connect(peerAddress, this.internalHandler, store));
    }

    protected void setConnection(Connection conn) {
        if (this.connection == conn) {
            return;
        }
        this.close();
        this.connection = conn;
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean isConnected() {
        Connection c = this.connection;
        return c != null && !c.isClosed();
    }

    public void closeButMaintainConnection() {
        this.connection = null;
        this.close();
    }

    @Override
    public CompletableFuture<State> acquireState() throws TimeoutException {
        try {
            CompletableFuture<Result> sF = this.requestStatus();
            AVector status = (AVector)((Result)sF.get(this.timeout, TimeUnit.MILLISECONDS)).getValue();
            Hash stateHash = RT.ensureHash((ACell)status.get(4));
            if (stateHash == null) {
                throw new Error("Bad status response from Peer");
            }
            return this.acquire(stateHash);
        }
        catch (InterruptedException | ExecutionException e) {
            throw (RuntimeException)Utils.sneakyThrow(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CompletableFuture<Result> transact(SignedData<ATransaction> signed) throws IOException {
        CompletableFuture<Result> cf;
        long id = -1L;
        HashMap hashMap = this.awaiting;
        synchronized (hashMap) {
            while (id < 0L) {
                id = this.connection.sendTransaction(signed);
                if (id >= 0L) continue;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            cf = this.awaitResult(id);
        }
        log.debug("Sent transaction with message ID: {} awaiting count = {}", (Object)id, (Object)this.awaiting.size());
        return cf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Result> query(ACell query, Address address) throws IOException {
        HashMap hashMap = this.awaiting;
        synchronized (hashMap) {
            long id = this.connection.sendQuery(query, address);
            if (id < 0L) {
                throw new IOException("Failed to send query due to full buffer");
            }
            return this.awaitResult(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Result> requestStatus() {
        try {
            HashMap hashMap = this.awaiting;
            synchronized (hashMap) {
                long id = this.connection.sendStatusRequest();
                if (id < 0L) {
                    return CompletableFuture.failedFuture(new IOException("Failed to send status request due to full buffer"));
                }
                CompletableFuture<Result> cf = this.awaitResult(id);
                return cf;
            }
        }
        catch (Throwable t) {
            return CompletableFuture.failedFuture(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Result> requestChallenge(SignedData<ACell> data) throws IOException {
        HashMap hashMap = this.awaiting;
        synchronized (hashMap) {
            long id = this.connection.sendChallenge(data);
            if (id < 0L) {
                throw new IOException("Failed to send challenge due to full buffer");
            }
            return this.awaitResult(id);
        }
    }

    @Override
    public <T extends ACell> CompletableFuture<T> acquire(final Hash hash, final AStore store) {
        final CompletableFuture f = new CompletableFuture();
        new Thread(new Runnable(){

            @Override
            public void run() {
                Stores.setCurrent(store);
                try {
                    Ref<Object> ref = store.refForHash(hash);
                    HashSet<Hash> missingSet = new HashSet<Hash>();
                    while (!f.isDone()) {
                        missingSet.clear();
                        if (ref == null) {
                            missingSet.add(hash);
                        } else {
                            if (ref.getStatus() >= 2) {
                                f.complete(ref.getValue());
                                return;
                            }
                            ref.findMissing(missingSet);
                        }
                        for (Hash h : missingSet) {
                            log.debug("Request missing data: {}", (Object)h);
                            boolean sent = ConvexRemote.this.connection.sendMissingData(h);
                            if (sent) continue;
                            log.debug("Send Queue full!");
                            break;
                        }
                        Thread.sleep(100L);
                        ref = store.refForHash(hash);
                        if (ref == null) continue;
                        if (ref.getStatus() >= 2) {
                            f.complete(ref.getValue());
                            return;
                        }
                        try {
                            ref = ref.persist();
                            f.complete(ref.getValue());
                        }
                        catch (MissingDataException e) {
                            Hash missing = e.getMissingHash();
                            log.debug("Still missing: {}", (Object)missing);
                            ConvexRemote.this.connection.sendMissingData(missing);
                        }
                    }
                }
                catch (Throwable t) {
                    f.completeExceptionally(t);
                }
            }
        }).start();
        return f;
    }

    @Override
    public synchronized void close() {
        Connection c = this.connection;
        if (c != null) {
            c.close();
        }
        this.connection = null;
        this.awaiting.clear();
    }

    public static ConvexRemote wrap(Connection c) {
        ConvexRemote convex = new ConvexRemote(null, null);
        convex.setConnection(c);
        return convex;
    }
}

