/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.components.tabbedpane;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import mdlaf.animation.MaterialMouseHover;
import mdlaf.components.button.MaterialButtonUI;
import mdlaf.utils.MaterialDrawingUtils;

public class MaterialTabbedPaneUI
extends BasicTabbedPaneUI {
    protected Color selectedForeground;
    protected Color disabledForeground;
    protected Color areaContentBackground;
    protected Color selectedAreaContentBackground;
    protected Color disableAreaContentBackground;
    protected Color foreground;
    protected int positionYLine;
    protected int positionXLine;
    protected int widthLine;
    protected int heightLine;
    protected int arcLine;
    protected int margin;
    protected int heightTab;
    protected boolean tabsOverlapBorder;
    protected Map<Integer, Boolean> mouseHoverInitialized = new HashMap<Integer, Boolean>();
    protected Boolean mouseHoverEnabled;
    protected MaterialMouseHoverOnTab mouseHoverTab;

    public static ComponentUI createUI(JComponent c) {
        return new MaterialTabbedPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.tabPane.setOpaque(false);
        this.foreground = new ColorUIResource(UIManager.getColor("TabbedPane.foreground"));
        this.selectedForeground = new ColorUIResource(UIManager.getColor("TabbedPane.selectionForeground"));
        this.disabledForeground = UIManager.getColor("TabbedPane.disabledForeground");
        this.areaContentBackground = new ColorUIResource(UIManager.getColor("TabbedPane.contentAreaColor"));
        this.disableAreaContentBackground = new ColorUIResource(UIManager.getColor("TabbedPane.disableContentAreaColor"));
        this.selectedAreaContentBackground = new ColorUIResource(UIManager.getColor("TabbedPane[focus].colorLine"));
        this.darkShadow = UIManager.getColor("TabbedPane.darkShadow");
        this.shadow = UIManager.getColor("TabbedPane.shadow");
        this.lightHighlight = UIManager.getColor("TabbedPane.highlight");
        this.widthLine = UIManager.getInt("TabbedPane.lineWidth");
        this.heightLine = UIManager.getInt("TabbedPane.lineHeight");
        this.arcLine = UIManager.getInt("TabbedPane.lineArch");
        this.margin = UIManager.getInt("TabbedPane[focus].margin");
        this.heightTab = UIManager.getInt("TabbedPane[tab].height");
        this.tabsOverlapBorder = UIManager.getBoolean("TabbedPane.tabsOverlapBorder");
        this.mouseHoverEnabled = UIManager.getBoolean("TabbedPane[MouseHover].enable");
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.darkShadow = null;
        this.shadow = null;
        this.lightHighlight = null;
        super.uninstallUI(c);
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        g = MaterialDrawingUtils.getAliasedGraphics(g);
        if (!this.tabPane.isEnabledAt(tabIndex)) {
            int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            MaterialDrawingUtils.drawString(this.tabPane, g, title, textRect, mnemIndex, 0, this.disabledForeground);
        } else {
            super.paintText(g, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
        }
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        Graphics2D g2D = (Graphics2D)g;
        if (isSelected) {
            g2D.setColor(this.selectedAreaContentBackground);
            g2D.setPaint(this.selectedAreaContentBackground);
            this.tabPane.setForegroundAt(tabIndex, this.selectedForeground);
        } else {
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
                g2D.setColor(this.tabPane.getBackground());
                g2D.setPaint(this.tabPane.getBackground());
            } else {
                g2D.setColor(this.disableAreaContentBackground);
                g2D.setPaint(this.disableAreaContentBackground);
            }
            if (this.tabPane.isEnabledAt(tabIndex)) {
                this.tabPane.setForegroundAt(tabIndex, this.foreground);
            } else {
                this.tabPane.setForegroundAt(tabIndex, this.disabledForeground);
            }
        }
    }

    @Override
    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        return this.heightTab + super.calculateTabHeight(tabPlacement, tabIndex, fontHeight);
    }

    @Override
    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        super.paintTab(g, tabPlacement, rects, tabIndex, iconRect, textRect);
        if (this.mouseHoverEnabled != null && this.mouseHoverEnabled.booleanValue() && this.mouseHoverTab == null) {
            this.mouseHoverTab = new MaterialMouseHoverOnTab(rects);
            this.tabPane.addMouseMotionListener(this.mouseHoverTab);
        }
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    @Override
    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        int width = this.tabPane.getWidth();
        int height = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        Insets tabAreaInsets = this.getTabAreaInsets(tabPlacement);
        int x = insets.left;
        int y = insets.top;
        int w = width - insets.right - insets.left;
        int h = height - insets.top - insets.bottom;
        switch (tabPlacement) {
            case 2: {
                x += this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                if (this.tabsOverlapBorder) {
                    x -= tabAreaInsets.right;
                }
                w -= x - insets.left;
                break;
            }
            case 4: {
                w -= this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                if (!this.tabsOverlapBorder) break;
                w += tabAreaInsets.left;
                break;
            }
            case 3: {
                h -= this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                if (!this.tabsOverlapBorder) break;
                h += tabAreaInsets.top;
                break;
            }
            default: {
                y += this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                if (this.tabsOverlapBorder) {
                    y -= tabAreaInsets.bottom;
                }
                h -= y - insets.top;
            }
        }
        if (tabPlacement == 1) {
            this.paintContentBorderTopEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        } else if (tabPlacement == 3) {
            this.paintContentBorderBottomEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        } else if (tabPlacement == 2) {
            this.paintContentBorderLeftEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        } else if (tabPlacement == 4) {
            this.paintContentBorderRightEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        }
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.lightHighlight);
        if (tabPlacement != 3 || selectedIndex < 0 || selRect.y - 1 > h || selRect.x < x || selRect.x > x + w) {
            g.drawLine(x + 1, y + h - 2, x + w - 2, y + h - 2);
            g.setColor(this.darkShadow);
            g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        } else {
            g.drawLine(x + 1, y + h - 2, selRect.x - 1, y + h - 2);
            g.setColor(this.selectedAreaContentBackground);
            g.fillRect(selRect.x, y + h - 2, selRect.width, this.heightLine);
            if (selRect.x + selRect.width < x + w - 2) {
                g.setColor(this.lightHighlight);
                g.drawLine(selRect.x + selRect.width, y + h - 2, x + w - 2, y + h - 2);
            }
        }
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.lightHighlight);
        if (tabPlacement != 2 || selectedIndex < 0 || selRect.x + selRect.width + 1 < x || selRect.y < y || selRect.y > y + h) {
            g.drawLine(x, y, x, y + h - 2);
        } else {
            g.setColor(this.selectedAreaContentBackground);
            g.fillRect(selRect.x + this.heightLine, selRect.y, this.heightLine, selRect.height);
        }
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.lightHighlight);
        if (tabPlacement != 4 || selectedIndex < 0 || selRect.x - 1 > w || selRect.y < y || selRect.y > y + h) {
            g.drawLine(x + w - 2, y + 1, x + w - 2, y + h - 3);
            g.setColor(this.darkShadow);
            g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
        } else {
            g.setColor(this.selectedAreaContentBackground);
            g.fillRect(selRect.x + selRect.width - this.heightLine - this.heightLine, selRect.y, this.heightLine, selRect.height);
        }
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.lightHighlight);
        if (tabPlacement != 1 || selectedIndex < 0 || selRect.y + selRect.height + 1 < y || selRect.x < x || selRect.x > x + w) {
            g.drawLine(x, y, x + w - 2, y);
        } else {
            g.drawLine(x, y, selRect.x - 1, y);
            if (selRect.x + selRect.width < x + w - 2) {
                g.drawLine(selRect.x + selRect.width, y, x + w - 2, y);
            }
            g.setColor(this.selectedAreaContentBackground);
            g.fillRect(selRect.x, y - this.heightLine + 1, selRect.width, this.heightLine);
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.tabPane.removeMouseMotionListener(this.mouseHoverTab);
    }

    @Override
    protected JButton createScrollButton(int direction) {
        return new ArrowButtonTabbedPane(direction);
    }

    protected class ArrowButtonTabbedPane
    extends JButton
    implements UIResource {
        private static final String PREFIX = "TabbedPane[scrollButton]";
        protected int direction;
        protected Icon disabled;
        protected Icon enabled;

        public ArrowButtonTabbedPane(int direction) {
            this.setUI(new ArrowButtonTabbedPaneUI(direction));
            this.direction = direction;
            switch (direction) {
                case 7: {
                    this.disabled = UIManager.getIcon(this.getPREFIX() + ".iconLeft");
                    this.enabled = UIManager.getIcon(this.getPREFIX() + ".disabledIconLeft");
                    break;
                }
                case 3: {
                    this.disabled = UIManager.getIcon(this.getPREFIX() + ".disabledIconRight");
                    this.enabled = UIManager.getIcon(this.getPREFIX() + ".iconRight");
                    break;
                }
                case 5: {
                    this.disabled = UIManager.getIcon(this.getPREFIX() + ".disabledBottomRight");
                    this.enabled = UIManager.getIcon(this.getPREFIX() + ".iconBottom");
                    break;
                }
                default: {
                    this.disabled = UIManager.getIcon(this.getPREFIX() + ".disabledIconTop");
                    this.enabled = UIManager.getIcon(this.getPREFIX() + ".iconTop");
                }
            }
            this.setIcon(this.enabled);
            this.setDisabledIcon(this.disabled);
        }

        public String getPREFIX() {
            return PREFIX;
        }

        @Override
        public void updateUI() {
            this.setUI(new ArrowButtonTabbedPaneUI(this.direction));
        }

        protected class ArrowButtonTabbedPaneUI
        extends MaterialButtonUI {
            protected int direction;

            public ArrowButtonTabbedPaneUI(int direction) {
                this.direction = direction;
            }

            @Override
            public void installUI(JComponent c) {
                this.mouseHoverEnabled = false;
                super.installUI(c);
                this.disabledBackground = this.background = UIManager.getColor("TabbedPane.background");
                this.borderEnabled = false;
                c.setBorder(BorderFactory.createMatteBorder(5, 5, 10, 5, this.background));
            }

            @Override
            protected void paintBackground(Graphics g, JComponent c) {
                super.paintBackground(g, c);
            }

            @Override
            protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
            }

            @Override
            protected void paintFocusRing(Graphics g, JButton b) {
            }
        }
    }

    protected class MaterialMouseHoverOnTab
    implements MaterialMouseHover {
        private Rectangle[] rectangles;

        public MaterialMouseHoverOnTab(Rectangle[] rectangles) {
            this.rectangles = rectangles;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            JComponent mouseGenerate = (JComponent)e.getSource();
            if (!mouseGenerate.isEnabled()) {
                return;
            }
            if (mouseGenerate.getCursor().equals(Cursor.getPredefinedCursor(3))) {
                return;
            }
            Point point = e.getPoint();
            for (Rectangle r : this.rectangles) {
                if (!r.contains(point)) continue;
                mouseGenerate.setCursor(Cursor.getPredefinedCursor(12));
                return;
            }
            mouseGenerate.setCursor(Cursor.getPredefinedCursor(0));
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public boolean isRunning() {
            return false;
        }
    }

    @Deprecated
    protected class MaterialTabbedPaneLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        protected int spacer;
        protected int indent;

        public MaterialTabbedPaneLayout() {
            super(MaterialTabbedPaneUI.this);
            this.spacer = UIManager.getInt("TabbedPane.spacer");
            this.indent = UIManager.getInt("TabbedPane.indent");
        }

        @Override
        protected void calculateTabRects(int tabPlacement, int tabCount) {
            if (this.spacer < 0) {
                throw new IllegalArgumentException("The spacer inside the " + this.getClass().getSimpleName() + " must be a not negative value");
            }
            super.calculateTabRects(tabPlacement, tabCount);
            if (tabPlacement == 1 || tabPlacement == 3) {
                for (int i = 0; i < MaterialTabbedPaneUI.this.rects.length; ++i) {
                    ((MaterialTabbedPaneUI)MaterialTabbedPaneUI.this).rects[i].x += i * this.spacer + this.indent;
                }
            }
        }
    }
}

