/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.components.combobox;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import mdlaf.animation.MaterialUIMovement;
import mdlaf.components.button.MaterialButtonsComponentsUI;
import mdlaf.components.combobox.MaterialComboBoxEditor;
import mdlaf.components.combobox.MaterialComboBoxRenderer;
import mdlaf.utils.MaterialBorders;
import mdlaf.utils.MaterialDrawingUtils;

public class MaterialComboBoxUI
extends BasicComboBoxUI {
    protected JButton arrowButton;
    protected Color background;
    protected FocusListenerColor focusListener;
    protected int arc = 10;
    protected Border disabledBorder;

    public static ComponentUI createUI(JComponent c) {
        return new MaterialComboBoxUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.background = UIManager.getColor("ComboBox.background");
        this.comboBox.setLightWeightPopupEnabled(true);
        this.comboBox.setCursor(Cursor.getPredefinedCursor(12));
        this.comboBox.setFocusable(UIManager.getBoolean("ComboBox.focusable"));
        this.disabledBorder = MaterialBorders.roundedLineColorBorder(UIManager.getColor("ComboBox.disabledColor"), this.arc);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.arc = UIManager.getInt("ComboBox.arc");
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(this.comboBox);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        if (!c.isEnabled()) {
            c.setBorder(this.disabledBorder);
        }
    }

    @Override
    protected JButton createArrowButton() {
        this.arrowButton = new ArrowButtonComboBox();
        return this.arrowButton;
    }

    @Override
    protected ComboPopup createPopup() {
        return new MaterialComboBoxPopup(this.comboBox);
    }

    @Override
    public void unconfigureArrowButton() {
        super.unconfigureArrowButton();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.focusListener = new FocusListenerColor();
        this.comboBox.addFocusListener(this.focusListener);
    }

    @Override
    protected void uninstallListeners() {
        if (this.focusListener != null) {
            this.comboBox.removeFocusListener(this.focusListener);
        }
        super.uninstallListeners();
    }

    @Override
    public void update(Graphics g, JComponent c) {
        g = MaterialDrawingUtils.getAliasedGraphics(g);
        g.setColor(c.getBackground());
        g.fillRoundRect(0, 0, this.comboBox.getWidth(), this.comboBox.getHeight(), this.arc, this.arc);
        this.paint(g, c);
    }

    @Override
    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        Component c;
        ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
        if (hasFocus && !this.isPopupVisible(this.comboBox)) {
            c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, true, false);
        } else {
            c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
            c.setBackground(UIManager.getColor("ComboBox.background"));
        }
        c.setFont(this.comboBox.getFont());
        if (this.comboBox.isEnabled()) {
            c.setForeground(this.comboBox.getForeground());
            c.setBackground(this.comboBox.getBackground());
        } else {
            c.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
            c.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
        }
        boolean shouldValidate = false;
        if (c instanceof JPanel) {
            shouldValidate = true;
        }
        int x = bounds.x;
        int y = bounds.y;
        int w = bounds.width;
        int h = bounds.height;
        if (this.padding != null) {
            x = bounds.x + this.padding.left;
            y = bounds.y + this.padding.top;
            w = bounds.width - (this.padding.left + this.padding.right);
            h = bounds.height - (this.padding.top + this.padding.bottom);
        }
        this.currentValuePane.paintComponent(g, c, this.comboBox, x, y, w, h, shouldValidate);
    }

    protected ListCellRenderer createRenderer() {
        return new MaterialComboBoxRenderer();
    }

    @Override
    protected ComboBoxEditor createEditor() {
        return new MaterialComboBoxEditor();
    }

    @Override
    protected FocusListener createFocusListener() {
        if (this.comboBox.isFocusable()) {
            this.comboBox.addFocusListener(this.focusListener);
        }
        return super.createFocusListener();
    }

    protected class ArrowButtonComboBox
    extends JButton {
        protected ArrowButtonComboBox() {
        }

        @Override
        public void updateUI() {
            this.setUI(new ArrowButtonComboboxBoxUI());
        }

        protected class ArrowIcon
        implements Icon,
        UIResource {
            protected Icon unselectedIcon;
            protected Icon selectedIcon;
            protected Icon disabledIcon;

            public ArrowIcon(String prefix) {
                this.unselectedIcon = UIManager.getIcon(prefix + "buttonIcon");
                this.disabledIcon = UIManager.getIcon(prefix + "buttonDisabledIcon");
                this.selectedIcon = UIManager.getIcon(prefix + "buttonSelectIcon");
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                if (MaterialComboBoxUI.this.comboBox.isEnabled()) {
                    if (MaterialComboBoxUI.this.comboBox.isPopupVisible()) {
                        this.selectedIcon.paintIcon(c, g, x, y);
                    } else {
                        this.unselectedIcon.paintIcon(c, g, x, y);
                    }
                } else {
                    this.disabledIcon.paintIcon(c, g, x, y);
                }
            }

            @Override
            public int getIconWidth() {
                return this.unselectedIcon.getIconWidth();
            }

            @Override
            public int getIconHeight() {
                return this.unselectedIcon.getIconHeight();
            }
        }

        protected class ArrowButtonComboboxBoxUI
        extends MaterialButtonsComponentsUI {
            protected ArrowButtonComboboxBoxUI() {
            }

            @Override
            public void installUI(JComponent c) {
                super.installUI(c);
                this.disabledBackground = this.background = UIManager.getColor("ComboBox.buttonBackground");
                c.setBackground(this.background);
                this.mouseHoverEnabled = UIManager.getBoolean("ComboBox.mouseHoverEnabled");
                if (this.mouseHoverEnabled.booleanValue()) {
                    c.addMouseListener(MaterialUIMovement.getMovement(MaterialComboBoxUI.this.arrowButton, UIManager.getColor("ComboBox.mouseHoverColor")));
                }
                this.button.setIcon(new ArrowIcon("ComboBox."));
                c.setBorder(UIManager.getBorder("ComboBox[button].border"));
            }
        }
    }

    protected class MaterialComboBoxPopup
    extends BasicComboPopup {
        public MaterialComboBoxPopup(JComboBox<Object> combo) {
            super(combo);
            this.setBorder(UIManager.getBorder("ComboBox[listItem].border"));
        }

        @Override
        public void show() {
            super.show();
            if (MaterialComboBoxUI.this.arrowButton != null) {
                MaterialComboBoxUI.this.arrowButton.repaint();
            }
        }

        @Override
        public void hide() {
            super.hide();
            if (MaterialComboBoxUI.this.arrowButton != null) {
                MaterialComboBoxUI.this.arrowButton.repaint();
            }
        }

        @Override
        protected void firePopupMenuCanceled() {
            super.firePopupMenuCanceled();
            if (MaterialComboBoxUI.this.arrowButton != null) {
                MaterialComboBoxUI.this.arrowButton.repaint();
            }
        }
    }

    protected class FocusListenerColor
    implements FocusListener {
        protected Border focus;
        protected Border unfocus;
        protected Border disabled;

        public FocusListenerColor() {
            this.focus = MaterialBorders.roundedLineColorBorder(UIManager.getColor("ComboBox.focusColor"), MaterialComboBoxUI.this.arc);
            this.unfocus = MaterialBorders.roundedLineColorBorder(UIManager.getColor("ComboBox.unfocusColor"), MaterialComboBoxUI.this.arc);
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (e.getComponent() == null) {
                return;
            }
            JComboBox cb = (JComboBox)e.getComponent();
            if (this.focus != null) {
                cb.setBorder(this.focus);
                cb.revalidate();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (e.getComponent() == null) {
                return;
            }
            JComboBox cb = (JComboBox)e.getComponent();
            if (this.unfocus != null) {
                cb.setBorder(this.unfocus);
                cb.revalidate();
            }
        }
    }
}

